/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.rhino;

import java.util.SortedMap;
import java.util.TreeMap;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.debug.DebugFrame;
import org.htmlunit.corejs.javascript.debug.DebuggableScript;
import org.jvnet.hudson.test.rhino.JavaScriptDebugger;

public class CallStackFrame
implements DebugFrame {
    public final JavaScriptDebugger owner;
    public final DebuggableScript fnOrScript;
    private Scriptable activation;
    private Scriptable thisObj;
    private Object[] args;
    private int line;

    public CallStackFrame(JavaScriptDebugger owner, DebuggableScript fnOrScript) {
        this.owner = owner;
        this.fnOrScript = fnOrScript;
    }

    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        this.activation = activation;
        this.thisObj = thisObj;
        this.args = args;
        this.owner.addCallStackFrame(this);
    }

    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        this.owner.removeCallStackFrame(this);
        this.activation = null;
        this.thisObj = null;
        this.args = null;
        this.line = -1;
    }

    public void onLineChange(Context cx, int lineNumber) {
        this.line = lineNumber;
    }

    public void onExceptionThrown(Context cx, Throwable ex) {
    }

    public void onDebuggerStatement(Context cx) {
    }

    public SortedMap<String, Object> getVariables() {
        TreeMap<String, Object> r = new TreeMap<String, Object>();
        for (int i = this.fnOrScript.getParamAndVarCount() - 1; i >= 0; --i) {
            String name = this.fnOrScript.getParamOrVarName(i);
            r.put(name, this.activation.get(name, this.activation));
        }
        return r;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fnOrScript.getFunctionName());
        buf.append('(');
        for (int i = 0; i < this.args.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.args[i]);
        }
        buf.append(')');
        buf.append("\n  at ").append(this.fnOrScript.getSourceName()).append('#').append(this.line);
        buf.append("\n  variables=").append(this.getVariables());
        return buf.toString();
    }
}

