/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ThreadPoolImpl
extends AbstractLifeCycle
implements ThreadPool {
    private final ExecutorService es;

    public ThreadPoolImpl(ExecutorService es) {
        this.es = es;
    }

    public void execute(@NonNull Runnable job) {
        if (!this.isRunning() || job == null) {
            throw new RejectedExecutionException();
        }
        this.es.submit(job);
    }

    public void join() throws InterruptedException {
        while (!this.es.awaitTermination(TimeUnit.DAYS.toSeconds(999L), TimeUnit.SECONDS)) {
        }
    }

    public int getThreads() {
        return 999;
    }

    public int getIdleThreads() {
        return 999;
    }

    public boolean isLowOnThreads() {
        return false;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        this.es.shutdown();
    }
}

