/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.ProcessTree;
import hudson.util.StreamCopyThread;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class SimpleCommandLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(SimpleCommandLauncher.class.getName());
    public final String cmd;
    private final Map<String, String> env;

    @DataBoundConstructor
    public SimpleCommandLauncher(String cmd) {
        this(cmd, null);
    }

    SimpleCommandLauncher(String cmd, EnvVars env) {
        this.cmd = cmd;
        this.env = env != null ? new HashMap(env) : null;
    }

    public void launch(SlaveComputer computer, TaskListener listener) {
        try {
            Slave node = computer.getNode();
            if (node == null) {
                throw new AbortException("Cannot launch commands on deleted nodes");
            }
            listener.getLogger().println("$ " + this.cmd);
            ProcessBuilder pb = new ProcessBuilder(Util.tokenize((String)this.cmd));
            final EnvVars cookie = EnvVars.createCookie();
            pb.environment().putAll((Map<String, String>)cookie);
            if (this.env != null) {
                pb.environment().putAll(this.env);
            }
            final Process proc = pb.start();
            new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), proc.getErrorStream(), (OutputStream)listener.getLogger()).start();
            computer.setChannel(proc.getInputStream(), proc.getOutputStream(), (OutputStream)listener.getLogger(), new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                    try {
                        ProcessTree.get().killAll(proc, (Map)cookie);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            });
            LOGGER.log(Level.INFO, "agent launched for {0}", computer.getName());
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, null, x);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
    }
}

