/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Queue;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jvnet.hudson.test.EndOfTestListener;

@Extension
public final class RemainingActivityListener
implements EndOfTestListener {
    private static final boolean fatal = Boolean.getBoolean(RemainingActivityListener.class.getName() + ".fatal");
    private static final boolean wait = Boolean.getBoolean(RemainingActivityListener.class.getName() + ".wait");

    @Override
    public void onTearDown() throws Exception {
        if (wait) {
            String problem;
            while ((problem = RemainingActivityListener.problem()) != null) {
                Logger.getLogger(RemainingActivityListener.class.getName()).warning(problem);
                Thread.sleep(5000L);
            }
        } else {
            String problem = RemainingActivityListener.problem();
            if (problem != null) {
                if (fatal) {
                    throw new AssertionError((Object)problem);
                }
                Logger.getLogger(RemainingActivityListener.class.getName()).warning(problem);
            }
        }
    }

    private static String problem() {
        for (Computer c : Jenkins.get().getComputers()) {
            for (Executor x : c.getAllExecutors()) {
                if (x.isIdle()) continue;
                return x.getCurrentExecutable() + " still seems to be running, which could break deletion of log files or metadata";
            }
        }
        int n = 0;
        Computer[] computerArray = Queue.getInstance().getItems();
        int n2 = computerArray.length;
        if (n < n2) {
            Computer q = computerArray[n];
            return (Queue.Item)q + " is still scheduled, which if it ever runs, could break deletion of log files or metadata";
        }
        return null;
    }
}

