/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.util.concurrent.TimeUnit;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;

public final class QueryUtils {
    private QueryUtils() {
    }

    public static void waitUntilStringIsPresent(HtmlPage page, String value) {
        long maxWaitTime = TimeUnit.SECONDS.toMillis(3L);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < maxWaitTime) {
            if (page.querySelector("*").getVisibleText().contains(value)) {
                System.out.println("Took '" + (System.currentTimeMillis() - startTime) + "ms' until string '" + value + "' was present");
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("String '" + value + "' was not present '" + value + "' after '" + maxWaitTime + "s'");
    }

    public static void waitUntilStringIsNotPresent(HtmlPage page, String value) {
        long maxWaitTime = TimeUnit.SECONDS.toMillis(3L);
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < maxWaitTime) {
            if (page.querySelector("*").getVisibleText().contains(value)) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            System.out.println("Took '" + (System.currentTimeMillis() - startTime) + "ms' until string '" + value + "' was no longer present");
            return;
        }
        throw new RuntimeException("String '" + value + "' is still present '" + value + "' after '" + maxWaitTime + "s'");
    }

    public static HtmlElement waitUntilElementIsPresent(HtmlPage page, String query) {
        long maxWaitTime = TimeUnit.SECONDS.toMillis(3L);
        long startTime = System.currentTimeMillis();
        HtmlElement element = null;
        while (element == null && System.currentTimeMillis() - startTime < maxWaitTime) {
            try {
                element = (HtmlElement)page.querySelector(query);
            }
            catch (Exception ignored) {
                System.out.println("Looking again for element: " + query);
            }
            if (element != null) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return element;
    }
}

