/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;

public final class PrefixedOutputStream
extends LineTransformationOutputStream.Delegating {
    @CheckForNull
    private final String name;
    @CheckForNull
    private final AnsiColor color;

    public static Builder builder() {
        return new Builder();
    }

    private PrefixedOutputStream(OutputStream out, String name, AnsiColor color) {
        super(out);
        this.name = name;
        this.color = color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eol(byte[] b, int len) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            if (this.name != null) {
                this.out.write(91);
                this.out.write(this.name.getBytes(StandardCharsets.US_ASCII));
                this.out.write(93);
                this.out.write(32);
            }
            if (this.color != null) {
                int preNlLen;
                this.out.write(27);
                this.out.write(91);
                this.out.write(this.color.getCode().getBytes(StandardCharsets.US_ASCII));
                this.out.write(109);
                for (preNlLen = len; preNlLen > 0 && (b[preNlLen - 1] == 10 || b[preNlLen - 1] == 13); --preNlLen) {
                }
                assert (0 <= preNlLen);
                assert (preNlLen <= len);
                assert (len <= b.length);
                this.out.write(b, 0, preNlLen);
                this.out.write(27);
                this.out.write(91);
                this.out.write(48);
                this.out.write(109);
                this.out.write(b, preNlLen, len - preNlLen);
            } else {
                this.out.write(b, 0, len);
            }
        }
    }

    public static final class Builder
    implements Serializable {
        static boolean SKIP_CHECK_FOR_CI;
        @CheckForNull
        private String name;
        @CheckForNull
        private AnsiColor color;

        private Builder() {
        }

        public Builder withName(@CheckForNull String name) {
            this.name = name;
            return this;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        public Builder withColor(@CheckForNull AnsiColor color) {
            if (SKIP_CHECK_FOR_CI || !"true".equals(System.getenv("CI"))) {
                this.color = color;
            }
            return this;
        }

        @CheckForNull
        public AnsiColor getColor() {
            return this.color;
        }

        @NonNull
        public OutputStream build(@NonNull OutputStream delegate) {
            return this.name != null || this.color != null ? new PrefixedOutputStream(delegate, this.name, this.color) : delegate;
        }
    }

    public static interface AnsiColor {
        public String getCode();
    }

    public static enum Color implements AnsiColor
    {
        RED("31"),
        GREEN("32"),
        YELLOW("33"),
        BLUE("34"),
        MAGENTA("35"),
        CYAN("36");

        private final String code;

        private Color(String code) {
            this.code = code;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        public AnsiColor bold() {
            return new Color16(this, true);
        }
    }

    private static class Color16
    implements AnsiColor,
    Serializable {
        private final Color color;
        private final boolean bold;

        Color16(Color color, boolean bold) {
            this.color = color;
            this.bold = bold;
        }

        @Override
        public String getCode() {
            return this.color.code + (this.bold ? ";1" : "");
        }
    }
}

