/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.StreamCopyThread;
import hudson.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.junit.rules.ExternalResource;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.PrefixedOutputStream;
import org.jvnet.hudson.test.RealJenkinsRule;

public final class InboundAgentRule
extends ExternalResource {
    private static final Logger LOGGER = Logger.getLogger(InboundAgentRule.class.getName());
    private final ConcurrentMap<String, Process> procs = new ConcurrentHashMap<String, Process>();

    public Slave createAgent(@NonNull JenkinsRule r, @CheckForNull String name) throws Exception {
        return this.createAgent(r, Options.newBuilder().name(name).build());
    }

    public Slave createAgent(@NonNull JenkinsRule r, Options options) throws Exception {
        Slave s = InboundAgentRule.createAgentJR(r, options);
        if (options.isStart()) {
            this.start(r, options);
        }
        return s;
    }

    public void createAgent(@NonNull RealJenkinsRule rr, @CheckForNull String name) throws Throwable {
        this.createAgent(rr, Options.newBuilder().name(name).build());
    }

    public void createAgent(@NonNull RealJenkinsRule rr, Options options) throws Throwable {
        String name;
        options.name = name = rr.runRemotely(InboundAgentRule::createAgentRJR, options);
        if (options.isStart()) {
            this.start(rr, options);
        }
    }

    public void start(@NonNull JenkinsRule r, @NonNull String name) throws Exception {
        this.start(r, Options.newBuilder().name(name).build());
    }

    public void start(@NonNull JenkinsRule r, Options options) throws Exception {
        String name = options.getName();
        Objects.requireNonNull(name);
        this.stop(r, name);
        this.start(InboundAgentRule.getAgentArguments(r, name), options);
        InboundAgentRule.waitForAgentOnline(r, name, options.loggers);
    }

    public void start(@NonNull RealJenkinsRule r, Options options) throws Throwable {
        String name = options.getName();
        Objects.requireNonNull(name);
        this.stop(r, name);
        this.start(r.runRemotely(InboundAgentRule::getAgentArguments, name), options);
        r.runRemotely(InboundAgentRule::waitForAgentOnline, name, options.loggers);
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION", "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="just for test code")
    public void start(AgentArguments agentArguments, Options options) throws Exception {
        Objects.requireNonNull(options.getName());
        this.stop(options.getName());
        ArrayList<String> cmd = new ArrayList<String>(List.of(JavaEnvUtils.getJreExecutable((String)"java"), "-Xmx512m", "-XX:+PrintCommandLineFlags", "-Djava.awt.headless=true"));
        if (JenkinsRule.SLAVE_DEBUG_PORT > 0) {
            cmd.add("-Xdebug");
            cmd.add("Xrunjdwp:transport=dt_socket,server=y,address=" + (JenkinsRule.SLAVE_DEBUG_PORT + agentArguments.numberOfNodes - 1));
        }
        cmd.addAll(List.of("-jar", agentArguments.agentJar.getAbsolutePath()));
        if (agentArguments.agentJnlpUrl.endsWith("computer/" + options.getName() + "/slave-agent.jnlp") && InboundAgentRule.remotingVersion(agentArguments.agentJar).isNewerThanOrEqualTo(new VersionNumber("3186.vc3b_7249b_87eb_"))) {
            cmd.addAll(List.of("-url", agentArguments.agentJnlpUrl.replaceAll("computer/" + options.getName() + "/slave-agent.jnlp$", "")));
            cmd.addAll(List.of("-secret", agentArguments.secret));
            cmd.addAll(List.of("-name", options.getName()));
            if (options.isWebSocket()) {
                cmd.add("-webSocket");
            }
            if (options.getTunnel() != null) {
                cmd.addAll(List.of("-tunnel", options.getTunnel()));
            }
        } else {
            cmd.addAll(List.of("-jnlpUrl", agentArguments.agentJnlpUrl));
            if (options.isSecret()) {
                cmd.addAll(List.of("-secret", agentArguments.secret));
            }
        }
        cmd.addAll(agentArguments.commandLineArgs);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        LOGGER.info(() -> "Running: " + pb.command());
        Process proc = pb.start();
        this.procs.put(options.getName(), proc);
        new StreamCopyThread("inbound-agent-" + options.getName(), proc.getInputStream(), options.prefixedOutputStreamBuilder.build(System.err)).start();
    }

    private static VersionNumber remotingVersion(File agentJar) throws IOException {
        try (JarFile j = new JarFile(agentJar);){
            String v = j.getManifest().getMainAttributes().getValue("Version");
            if (v == null) {
                throw new IOException("no Version in " + agentJar);
            }
            VersionNumber versionNumber = new VersionNumber(v);
            return versionNumber;
        }
    }

    public void stop(@NonNull JenkinsRule r, @NonNull String name) throws InterruptedException {
        this.stop(name);
        InboundAgentRule.waitForAgentOffline(r, name);
    }

    public void stop(@NonNull RealJenkinsRule rjr, @NonNull String name) throws Throwable {
        this.stop(name);
        if (rjr.isAlive()) {
            rjr.runRemotely(InboundAgentRule::waitForAgentOffline, name);
        } else {
            LOGGER.warning(() -> "Controller seems to have already shut down; not waiting for " + name + " to go offline");
        }
    }

    public void stop(@NonNull String name) throws InterruptedException {
        Process proc = (Process)this.procs.remove(name);
        if (proc != null) {
            proc.destroyForcibly();
            proc.waitFor();
        }
    }

    public boolean isAlive(String name) {
        Process proc = (Process)this.procs.get(name);
        return proc != null && proc.isAlive();
    }

    protected void after() {
        for (String name : this.procs.keySet()) {
            try {
                this.stop(name);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static AgentArguments getAgentArguments(JenkinsRule r, String name) throws IOException {
        File agentJar;
        Node node = r.jenkins.getNode(name);
        if (node == null) {
            throw new AssertionError((Object)("no such agent: " + name));
        }
        SlaveComputer c = (SlaveComputer)node.toComputer();
        if (c == null) {
            throw new AssertionError((Object)("agent " + node + " has no executor"));
        }
        JNLPLauncher launcher = (JNLPLauncher)c.getLauncher();
        List commandLineArgs = List.of();
        if (!launcher.getWorkDirSettings().isDisabled()) {
            commandLineArgs = launcher.getWorkDirSettings().toCommandLineArgs(c);
        }
        if (!(agentJar = new File(r.jenkins.getRootDir(), "agent.jar")).isFile()) {
            FileUtils.copyURLToFile((URL)new Slave.JnlpJar("agent.jar").getURL(), (File)agentJar);
        }
        return new AgentArguments(r.jenkins.getRootUrl() + "computer/" + name + "/slave-agent.jnlp", agentJar, c.getJnlpMac(), r.jenkins.getNodes().size(), commandLineArgs);
    }

    private static void waitForAgentOnline(JenkinsRule r, String name, Map<String, Level> loggers) throws Exception {
        Node node = r.jenkins.getNode(name);
        if (node == null) {
            throw new AssertionError((Object)("no such agent: " + name));
        }
        if (!(node instanceof Slave)) {
            throw new AssertionError((Object)("agent is not a Slave: " + name));
        }
        r.waitOnline((Slave)node);
        if (!loggers.isEmpty()) {
            VirtualChannel channel = node.getChannel();
            assert (channel != null);
            channel.call((Callable)new JenkinsRule.RemoteLogDumper(null, loggers, false));
        }
    }

    private static void waitForAgentOffline(JenkinsRule r, String name) throws InterruptedException {
        Computer c = r.jenkins.getComputer(name);
        if (c != null) {
            while (c.isOnline()) {
                Thread.sleep(100L);
            }
        }
    }

    private static String createAgentRJR(JenkinsRule r, Options options) throws Throwable {
        InboundAgentRule.createAgentJR(r, options);
        return options.getName();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="just for test code")
    private static Slave createAgentJR(JenkinsRule r, Options options) throws Descriptor.FormException, IOException, InterruptedException {
        if (options.getName() == null) {
            options.name = "agent" + r.jenkins.getNodes().size();
        }
        JNLPLauncher launcher = new JNLPLauncher(options.getTunnel());
        launcher.setWebSocket(options.isWebSocket());
        DumbSlave s = new DumbSlave(options.getName(), new File(r.jenkins.getRootDir(), "agent-work-dirs/" + options.getName()).getAbsolutePath(), (ComputerLauncher)launcher);
        s.setLabelString(options.getLabel());
        s.setRetentionStrategy(RetentionStrategy.NOOP);
        r.jenkins.addNode((Node)s);
        Computer computer = s.toComputer();
        while (computer == null || computer.getOfflineCause() == null) {
            Thread.sleep(100L);
            computer = s.toComputer();
        }
        return s;
    }

    public static final class Options
    implements Serializable {
        @CheckForNull
        private String name;
        @Deprecated
        private boolean secret;
        private boolean webSocket;
        @CheckForNull
        private String tunnel;
        private boolean start = true;
        private final LinkedHashMap<String, Level> loggers = new LinkedHashMap();
        private String label;
        private final PrefixedOutputStream.Builder prefixedOutputStreamBuilder = PrefixedOutputStream.builder();

        public String getName() {
            return this.name;
        }

        @Deprecated
        public boolean isSecret() {
            return this.secret;
        }

        public boolean isWebSocket() {
            return this.webSocket;
        }

        public String getTunnel() {
            return this.tunnel;
        }

        public boolean isStart() {
            return this.start;
        }

        public String getLabel() {
            return this.label;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private final Options options = new Options();

            private Builder() {
            }

            public Builder name(String name) {
                this.options.name = name;
                return this;
            }

            public Builder color(PrefixedOutputStream.AnsiColor color) {
                this.options.prefixedOutputStreamBuilder.withColor(color);
                return this;
            }

            @Deprecated
            public Builder secret() {
                this.options.secret = true;
                return this;
            }

            public Builder webSocket() {
                return this.webSocket(true);
            }

            public Builder webSocket(boolean websocket) {
                this.options.webSocket = websocket;
                return this;
            }

            public Builder tunnel(String tunnel) {
                this.options.tunnel = tunnel;
                return this;
            }

            public Builder skipStart() {
                this.options.start = false;
                return this;
            }

            public Builder label(String label) {
                this.options.label = label;
                return this;
            }

            public Builder withLogger(Class<?> clazz, Level level) {
                return this.withLogger(clazz.getName(), level);
            }

            public Builder withPackageLogger(Class<?> clazz, Level level) {
                return this.withLogger(clazz.getPackageName(), level);
            }

            public Builder withLogger(String logger, Level level) {
                this.options.loggers.put(logger, level);
                return this;
            }

            public Options build() {
                return this.options;
            }
        }
    }

    public static class AgentArguments
    implements Serializable {
        @NonNull
        private final String agentJnlpUrl;
        @NonNull
        private final File agentJar;
        @NonNull
        private final String secret;
        private final int numberOfNodes;
        @NonNull
        private final List<String> commandLineArgs;

        public AgentArguments(@NonNull String agentJnlpUrl, @NonNull File agentJar, @NonNull String secret, int numberOfNodes, @NonNull List<String> commandLineArgs) {
            this.agentJnlpUrl = agentJnlpUrl;
            this.agentJar = agentJar;
            this.secret = secret;
            this.numberOfNodes = numberOfNodes;
            this.commandLineArgs = commandLineArgs;
        }
    }
}

