/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.NullSCM;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xml.sax.SAXException;

public class FakeChangeLogSCM
extends NullSCM
implements Serializable {
    private List<EntryImpl> entries = new ArrayList<EntryImpl>();
    private static final long serialVersionUID = 1L;

    public EntryImpl addChange() {
        EntryImpl e = new EntryImpl();
        this.entries.add(e);
        return e;
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath remoteDir, TaskListener listener, File changeLogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        new FilePath(changeLogFile).touch(0L);
        build.addAction((Action)new ChangelogAction(this.entries, changeLogFile.getName()));
        this.entries = new ArrayList<EntryImpl>();
    }

    public ChangeLogParser createChangeLogParser() {
        return new FakeChangeLogParser();
    }

    public SCMDescriptor<?> getDescriptor() {
        return new SCMDescriptor<SCM>(null){};
    }

    public static class EntryImpl
    extends ChangeLogSet.Entry
    implements Serializable {
        private String msg = "some commit message";
        private String author = "someone";
        private String path = "path";
        private static final long serialVersionUID = 1L;

        public EntryImpl withAuthor(String author) {
            this.author = author;
            return this;
        }

        public EntryImpl withMsg(String msg) {
            this.msg = msg;
            return this;
        }

        public EntryImpl withPath(String path) {
            this.path = path;
            return this;
        }

        public String getMsg() {
            return this.msg;
        }

        public User getAuthor() {
            return User.get((String)this.author);
        }

        public Collection<String> getAffectedPaths() {
            return Set.of(this.path);
        }

        public Collection<ChangeLogSet.AffectedFile> getAffectedFiles() {
            ChangeLogSet.AffectedFile affectedFile = new ChangeLogSet.AffectedFile(){

                public String getPath() {
                    return path;
                }

                public EditType getEditType() {
                    return EditType.EDIT;
                }
            };
            return Set.of(affectedFile);
        }
    }

    public static class ChangelogAction
    extends InvisibleAction {
        private final List<EntryImpl> entries;
        private final String changeLogFile;

        public ChangelogAction(List<EntryImpl> entries, String changeLogFile) {
            this.entries = entries;
            this.changeLogFile = changeLogFile;
        }
    }

    public static class FakeChangeLogParser
    extends ChangeLogParser {
        public FakeChangeLogSet parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
            for (ChangelogAction action : build.getActions(ChangelogAction.class)) {
                if (!changelogFile.getName().equals(action.changeLogFile)) continue;
                return new FakeChangeLogSet(build, action.entries);
            }
            return new FakeChangeLogSet(build, List.of());
        }
    }

    public static class FakeChangeLogSet
    extends ChangeLogSet<EntryImpl>
    implements Serializable {
        private List<EntryImpl> entries;
        private static final long serialVersionUID = 1L;

        public FakeChangeLogSet(Run<?, ?> build, List<EntryImpl> entries) {
            super(build, null);
            this.entries = entries;
        }

        public boolean isEmptySet() {
            return this.entries.isEmpty();
        }

        public Iterator<EntryImpl> iterator() {
            return this.entries.iterator();
        }
    }
}

