/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex.dh;

import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.digest.Digest;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyExchange;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.math.BigInteger;
import java.util.Objects;

public abstract class AbstractDHKeyExchange
extends AbstractLoggingBean
implements KeyExchange {
    protected byte[] v_s;
    protected byte[] v_c;
    protected byte[] i_s;
    protected byte[] i_c;
    protected Digest hash;
    protected byte[] k;
    protected byte[] h;
    private byte[] e;
    private BigInteger eValue;
    private byte[] f;
    private BigInteger fValue;
    private final Session session;

    protected AbstractDHKeyExchange(Session session) {
        this.session = Objects.requireNonNull(session, "No session provided");
    }

    @Override
    public void init(byte[] v_s, byte[] v_c, byte[] i_s, byte[] i_c) throws Exception {
        this.v_s = ValidateUtils.checkNotNullAndNotEmpty(v_s, "No v_s value");
        this.v_c = ValidateUtils.checkNotNullAndNotEmpty(v_c, "No v_c value");
        this.i_s = ValidateUtils.checkNotNullAndNotEmpty(i_s, "No i_s value");
        this.i_c = ValidateUtils.checkNotNullAndNotEmpty(i_c, "No i_c value");
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Digest getHash() {
        return this.hash;
    }

    @Override
    public byte[] getH() {
        return this.h;
    }

    @Override
    public byte[] getK() {
        return this.k;
    }

    protected byte[] getE() {
        return this.e;
    }

    protected BigInteger getEValue() {
        if (this.eValue == null) {
            this.eValue = BufferUtils.fromMPIntBytes(this.getE());
        }
        return this.eValue;
    }

    protected byte[] updateE(Buffer buffer) {
        return this.updateE(buffer.getMPIntAsBytes());
    }

    protected byte[] updateE(byte[] mpInt) {
        this.setE(mpInt);
        return mpInt;
    }

    protected void setE(byte[] e) {
        this.e = e;
        if (this.eValue != null) {
            this.eValue = null;
        }
    }

    protected void validateEValue(BigInteger pValue) throws SshException {
        BigInteger value = Objects.requireNonNull(this.getEValue(), "No DH 'e' value set");
        if (!KeyExchange.isValidDHValue(value, pValue)) {
            throw new SshException(3, "Protocol error: invalid DH 'e' value");
        }
    }

    protected byte[] getF() {
        return this.f;
    }

    protected BigInteger getFValue() {
        if (this.fValue == null) {
            this.fValue = BufferUtils.fromMPIntBytes(this.getF());
        }
        return this.fValue;
    }

    protected byte[] updateF(Buffer buffer) {
        return this.updateF(buffer.getMPIntAsBytes());
    }

    protected byte[] updateF(byte[] mpInt) {
        this.setF(mpInt);
        return mpInt;
    }

    protected void setF(byte[] f) {
        this.f = f;
        if (this.fValue != null) {
            this.fValue = null;
        }
    }

    protected void validateFValue(BigInteger pValue) throws SshException {
        BigInteger value = Objects.requireNonNull(this.getFValue(), "No DH 'f' value set");
        if (!KeyExchange.isValidDHValue(value, pValue)) {
            throw new SshException(3, "Protocol error: invalid DH 'f' value");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

