/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh.kdf;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.Cipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.CipherFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh.kdf.BCrypt;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ExceptionUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public class BCryptKdfOptions
implements OpenSSHKdfOptions {
    public static final String NAME = "bcrypt";
    public static final int DEFAULT_MAX_ROUNDS = 255;
    private static final AtomicInteger MAX_ROUNDS_HOLDER = new AtomicInteger(255);
    private byte[] salt;
    private int numRounds;

    @Override
    public void initialize(String name, byte[] kdfOptions) throws IOException {
        if (!NAME.equalsIgnoreCase(name)) {
            throw new StreamCorruptedException("Mismatched KDF name: " + name);
        }
        if (NumberUtils.isEmpty(kdfOptions)) {
            throw new StreamCorruptedException("Missing KDF options for " + name);
        }
        int expectedSaltLength = kdfOptions.length - 8;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(kdfOptions);){
            this.initialize(stream, expectedSaltLength);
        }
        byte[] saltValue = this.getSalt();
        int actualSaltLength = NumberUtils.length(saltValue);
        if (actualSaltLength != expectedSaltLength) {
            throw new StreamCorruptedException("Mismatched salt data length: expected=" + expectedSaltLength + ", actual=" + actualSaltLength);
        }
    }

    protected void initialize(InputStream stream, int maxSaltSize) throws IOException {
        this.setSalt(KeyEntryResolver.readRLEBytes(stream, maxSaltSize));
        this.setNumRounds(KeyEntryResolver.decodeInt(stream));
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decodePrivateKeyBytes(SessionContext session, NamedResource resourceKey, CipherFactory cipherSpec, byte[] privateDataBytes, String password) throws IOException, GeneralSecurityException {
        byte[] result222222;
        int macLength;
        byte[] pwd;
        byte[] cipherInput;
        byte[] sensitive;
        byte[] iv;
        byte[] kv;
        block24: {
            if (NumberUtils.isEmpty(privateDataBytes)) {
                return privateDataBytes;
            }
            int blockSize = cipherSpec.getCipherBlockSize();
            if (privateDataBytes.length % blockSize != 0) {
                throw new StreamCorruptedException("Encrypted data size (" + privateDataBytes.length + ") is not aligned to  " + cipherSpec.getName() + " block size (" + blockSize + ")");
            }
            int keySize = cipherSpec.getKdfSize();
            int ivSize = cipherSpec.getIVSize();
            boolean isChaCha = "chacha20-poly1305@openssh.com".equals(cipherSpec.getName());
            kv = null;
            iv = null;
            sensitive = null;
            cipherInput = new byte[isChaCha ? keySize : keySize + ivSize];
            pwd = password.getBytes(StandardCharsets.UTF_8);
            this.bcryptKdf(pwd, cipherInput);
            kv = Arrays.copyOf(cipherInput, keySize);
            iv = new byte[ivSize];
            if (!isChaCha) {
                System.arraycopy(cipherInput, keySize, iv, 0, ivSize);
            }
            Cipher cipher = (Cipher)cipherSpec.create();
            sensitive = Arrays.copyOf(privateDataBytes, privateDataBytes.length);
            macLength = cipherSpec.getAuthenticationTagSize();
            cipher.init(Cipher.Mode.Decrypt, kv, iv);
            cipher.update(sensitive, 0, sensitive.length - macLength);
            if (macLength != 0) break block24;
            byte[] result222222 = sensitive;
            sensitive = null;
            byte[] byArray = result222222;
            Arrays.fill(pwd, (byte)0);
            Arrays.fill(cipherInput, (byte)0);
            if (kv != null) {
                Arrays.fill(kv, (byte)0);
            }
            if (iv != null) {
                Arrays.fill(iv, (byte)0);
            }
            if (sensitive != null) {
                Arrays.fill(sensitive, (byte)0);
            }
            return byArray;
        }
        try {
            result222222 = Arrays.copyOf(sensitive, sensitive.length - macLength);
        }
        catch (RuntimeException e) {
            try {
                Throwable t = ExceptionUtils.peelException(e);
                Throwable err = null;
                if (t instanceof IOException || t instanceof GeneralSecurityException) {
                    err = t;
                } else {
                    t = ExceptionUtils.resolveExceptionCause(e);
                    if (t instanceof IOException || t instanceof GeneralSecurityException) {
                        err = t;
                    }
                }
                if (err instanceof IOException) {
                    throw (IOException)err;
                }
                if (err instanceof GeneralSecurityException) {
                    throw (GeneralSecurityException)err;
                }
                throw e;
                catch (IOException | GeneralSecurityException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new GeneralSecurityException(e3);
                }
            }
            catch (Throwable throwable) {
                Arrays.fill(pwd, (byte)0);
                Arrays.fill(cipherInput, (byte)0);
                if (kv != null) {
                    Arrays.fill(kv, (byte)0);
                }
                if (iv != null) {
                    Arrays.fill(iv, (byte)0);
                }
                if (sensitive != null) {
                    Arrays.fill(sensitive, (byte)0);
                }
                throw throwable;
            }
        }
        Arrays.fill(pwd, (byte)0);
        Arrays.fill(cipherInput, (byte)0);
        if (kv != null) {
            Arrays.fill(kv, (byte)0);
        }
        if (iv != null) {
            Arrays.fill(iv, (byte)0);
        }
        if (sensitive != null) {
            Arrays.fill(sensitive, (byte)0);
        }
        return result222222;
    }

    protected void bcryptKdf(byte[] password, byte[] output) throws IOException, GeneralSecurityException {
        BCrypt bcrypt = new BCrypt();
        bcrypt.pbkdf(password, this.getSalt(), this.getNumRounds(), output);
    }

    @Override
    public final String getName() {
        return NAME;
    }

    public byte[] getSalt() {
        return NumberUtils.emptyIfNull(this.salt);
    }

    public void setSalt(byte[] salt) {
        this.salt = NumberUtils.emptyIfNull(salt);
    }

    public int getNumRounds() {
        return this.numRounds;
    }

    public void setNumRounds(int numRounds) {
        int maxAllowed = BCryptKdfOptions.getMaxAllowedRounds();
        if (numRounds <= 0 || numRounds > maxAllowed) {
            throw new BCryptBadRoundsException(numRounds, "Bad rounds value (" + numRounds + ") - max. allowed " + maxAllowed);
        }
        this.numRounds = numRounds;
    }

    public int hashCode() {
        return 31 * this.getNumRounds() + Arrays.hashCode(this.getSalt());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BCryptKdfOptions other = (BCryptKdfOptions)obj;
        return this.getNumRounds() == other.getNumRounds() && Arrays.equals(this.getSalt(), other.getSalt());
    }

    public String toString() {
        return this.getName() + ": rounds=" + this.getNumRounds() + ", salt=" + BufferUtils.toHex(':', this.getSalt());
    }

    public static int getMaxAllowedRounds() {
        return MAX_ROUNDS_HOLDER.get();
    }

    public static void setMaxAllowedRounds(int value) {
        ValidateUtils.checkTrue(value > 0, "Invalid max. rounds value: %d", value);
        MAX_ROUNDS_HOLDER.set(value);
    }

    public static class BCryptBadRoundsException
    extends RuntimeSshException {
        private static final long serialVersionUID = 1724985268892193553L;
        private final int rounds;

        public BCryptBadRoundsException(int rounds) {
            this(rounds, "Bad rounds value: " + rounds);
        }

        public BCryptBadRoundsException(int rounds, String message) {
            this(rounds, message, null);
        }

        public BCryptBadRoundsException(int rounds, String message, Throwable reason) {
            super(message, reason);
            this.rounds = rounds;
        }

        public int getRounds() {
            return this.rounds;
        }
    }
}

