/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.annotation_indexer;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jvnet.hudson.annotation_indexer.Indexed;

@SupportedAnnotationTypes(value={"*"})
public class AnnotationProcessorImpl
extends AbstractProcessor {
    protected Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || roundEnv.errorRaised()) {
            return false;
        }
        this.execute(annotations, roundEnv);
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    protected void execute(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, Use> output = new HashMap<String, Use>();
        this.scan(annotations, roundEnv, output);
        for (Use u : output.values()) {
            u.write();
        }
    }

    protected AnnotationMirror findAnnotationOn(Element e, String name) {
        for (AnnotationMirror annotationMirror : this.getElementUtils().getAllAnnotationMirrors(e)) {
            if (!this.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(name)) continue;
            return annotationMirror;
        }
        return null;
    }

    private void scan(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Map<String, Use> output) {
        for (TypeElement typeElement : annotations) {
            String annName;
            Use o;
            if (!this.isIndexing(typeElement)) continue;
            AnnotationMirror retention = this.findAnnotationOn(typeElement, Retention.class.getName());
            if (retention == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Specify @Retention(RUNTIME)", typeElement);
            }
            if ((o = output.get(annName = this.getElementUtils().getBinaryName(typeElement).toString())) == null) {
                o = new Use(annName);
                output.put(annName, o);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                AnnotationMirror marked = this.findAnnotationOn(element, annName);
                assert (marked != null);
                o.add(element);
            }
        }
    }

    protected boolean isIndexing(TypeElement ann) {
        AnnotationMirror indexed = this.findAnnotationOn(ann, Indexed.class.getName());
        return indexed != null;
    }

    private final class Use {
        final String annotationName;
        final Set<String> classes = new TreeSet<String>();
        final Set<Element> originatingElements = new HashSet<Element>();

        private Use(String annotationName) {
            this.annotationName = annotationName;
            try {
                this.classes.addAll(this.loadExisting());
            }
            catch (IOException x) {
                AnnotationProcessorImpl.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
            }
        }

        void add(Element elt) {
            TypeElement t;
            this.originatingElements.add(elt);
            switch (elt.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ANNOTATION_TYPE: 
                case ENUM: {
                    t = (TypeElement)elt;
                    break;
                }
                case METHOD: 
                case FIELD: 
                case CONSTRUCTOR: {
                    t = (TypeElement)elt.getEnclosingElement();
                    break;
                }
                case PACKAGE: {
                    this.classes.add(((PackageElement)elt).getQualifiedName().toString() + ".*");
                    return;
                }
                default: {
                    return;
                }
            }
            this.classes.add(AnnotationProcessorImpl.this.getElementUtils().getBinaryName(t).toString());
        }

        String getIndexFileName() {
            return "META-INF/services/annotations/" + this.annotationName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<String> loadExisting() throws IOException {
            ArrayList<String> elements = new ArrayList<String>();
            try {
                FileObject in = AnnotationProcessorImpl.this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.getIndexFileName());
                try (BufferedReader is = new BufferedReader(new InputStreamReader(in.openInputStream(), "UTF-8"));){
                    String line;
                    while ((line = is.readLine()) != null) {
                        elements.add(line);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write() {
            try {
                FileObject out = AnnotationProcessorImpl.this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", this.getIndexFileName(), this.originatingElements.toArray(new Element[this.originatingElements.size()]));
                try (PrintWriter w = new PrintWriter(new OutputStreamWriter(out.openOutputStream(), "UTF-8"));){
                    for (String el : this.classes) {
                        w.println(el);
                    }
                }
            }
            catch (IOException x) {
                AnnotationProcessorImpl.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, x.toString());
            }
        }
    }
}

