/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.base;

import cn.hutool.core.util.ObjectUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class BaseMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public BaseMap() {
    }

    public BaseMap(Map<String, Object> map) {
        this.putAll(map);
    }

    @Override
    public BaseMap put(String key, Object value) {
        super.put(key, Optional.ofNullable(value).orElse(""));
        return this;
    }

    public BaseMap add(String key, Object value) {
        super.put(key, Optional.ofNullable(value).orElse(""));
        return this;
    }

    public <T> T get(String key) {
        Object v = super.get(key);
        if (ObjectUtil.isNotEmpty(v)) {
            return (T)v;
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        Object v = super.get(key);
        if (ObjectUtil.isNotEmpty(v)) {
            return Boolean.valueOf(v.toString());
        }
        return false;
    }

    public Long getLong(String key) {
        Object t = this.get(key);
        if (ObjectUtil.isNotEmpty(t)) {
            return new Long(t.toString());
        }
        return null;
    }

    public Long[] getLongs(String key) {
        Object t = this.get(key);
        if (ObjectUtil.isNotEmpty(t)) {
            return (Long[])t;
        }
        return null;
    }

    public List<Long> getListLong(String key) {
        List list = (List)this.get(key);
        if (ObjectUtil.isNotEmpty((Object)list)) {
            return list.stream().map(e2 -> new Long((String)e2)).collect(Collectors.toList());
        }
        return null;
    }

    public Long[] getLongIds(String key) {
        Object t = this.get(key);
        if (ObjectUtil.isNotEmpty(t)) {
            return (Long[])Arrays.stream(t.toString().split(",")).map(String::trim).map(Long::valueOf).toArray(Long[]::new);
        }
        return null;
    }

    public Long[] convertIdsToLongArray(Collection<?> ids) {
        return (Long[])ids.stream().map(id -> Long.valueOf(id.toString())).toArray(Long[]::new);
    }

    public Integer getInt(String key, Integer def) {
        Object t = this.get(key);
        if (ObjectUtil.isNotEmpty(t)) {
            return Integer.parseInt(t.toString());
        }
        return def;
    }

    public Integer getInt(String key) {
        Object t = this.get(key);
        if (ObjectUtil.isNotEmpty(t)) {
            return Integer.parseInt(t.toString());
        }
        return 0;
    }

    public BigDecimal getBigDecimal(String key) {
        Object t = this.get(key);
        if (ObjectUtil.isNotEmpty(t)) {
            return new BigDecimal(t.toString());
        }
        return new BigDecimal("0");
    }

    public <T> T get(String key, T def) {
        Object v = super.get(key);
        if (ObjectUtil.isEmpty(v)) {
            return def;
        }
        return (T)v;
    }

    public static BaseMap toBaseMap(Map<String, Object> obj) {
        BaseMap baseMap = new BaseMap();
        baseMap.putAll(obj);
        return baseMap;
    }
}

