/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlInjectionUtil {
    private static final Log log = LogFactory.getLog(SqlInjectionUtil.class);
    private static final String XSS_STR = "and |exec |peformance_schema|information_schema|extractvalue|updatexml|geohash|gtid_subset|gtid_subtract|insert |select |delete |update |drop |count |chr |mid |master |truncate |char |declare |;|or |+|--";
    private static final String[] XSS_REGULAR_STR_ARRAY = new String[]{"chr\\s*\\(", "mid\\s*\\(", " char\\s*\\(", "sleep\\s*\\(", "user\\s*\\(", "show\\s+tables", "user[\\s]*\\([\\s]*\\)", "show\\s+databases", "sleep\\(\\d*\\)", "sleep\\(.*\\)"};
    private static final Pattern SQL_ANNOTATION = Pattern.compile("/\\*[\\s\\S]*\\*/");
    private static final String SQL_ANNOTATION2 = "--";
    private static final String SQL_INJECTION_KEYWORD_TIP = "\u8bf7\u6ce8\u610f\uff0c\u5b58\u5728SQL\u6ce8\u5165\u5173\u952e\u8bcd---> ";
    private static final String SQL_INJECTION_TIP = "\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!--->";
    private static final String SQL_INJECTION_TIP_VARIABLE = "\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669!---> ";

    public static void check(String value, String customXssString) {
        if (value == null || "".equals(value)) {
            return;
        }
        SqlInjectionUtil.checkSqlAnnotation(value);
        value = value.toLowerCase().trim();
        String[] xssArr = XSS_STR.split("\\|");
        for (int i = 0; i < xssArr.length; ++i) {
            if (value.indexOf(xssArr[i]) <= -1) continue;
            log.error((Object)(SQL_INJECTION_KEYWORD_TIP + xssArr[i]));
            log.error((Object)(SQL_INJECTION_TIP_VARIABLE + value));
            throw new RuntimeException(SQL_INJECTION_TIP + value);
        }
        if (customXssString != null) {
            String[] xssArr2 = customXssString.split("\\|");
            for (int i = 0; i < xssArr2.length; ++i) {
                if (value.indexOf(xssArr2[i]) <= -1) continue;
                log.error((Object)(SQL_INJECTION_KEYWORD_TIP + xssArr2[i]));
                log.error((Object)(SQL_INJECTION_TIP_VARIABLE + value));
                throw new RuntimeException(SQL_INJECTION_TIP + value);
            }
        }
        for (String regularOriginal : XSS_REGULAR_STR_ARRAY) {
            String regular = ".*" + regularOriginal + ".*";
            if (!Pattern.matches(regular, value)) continue;
            log.error((Object)(SQL_INJECTION_KEYWORD_TIP + regularOriginal));
            log.error((Object)(SQL_INJECTION_TIP_VARIABLE + value));
            throw new RuntimeException(SQL_INJECTION_TIP + value);
        }
    }

    public static void checkSqlAnnotation(String str) {
        if (str.contains(SQL_ANNOTATION2)) {
            String error = "\u8bf7\u6ce8\u610f\uff0cSQL\u4e2d\u4e0d\u5141\u8bb8\u542b\u6ce8\u91ca\uff0c\u6709\u5b89\u5168\u98ce\u9669---> --";
            log.error((Object)error);
            throw new RuntimeException(error);
        }
        Matcher matcher = SQL_ANNOTATION.matcher(str);
        if (matcher.find()) {
            String error = "\u8bf7\u6ce8\u610f\uff0c\u503c\u53ef\u80fd\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669---> \\*.*\\";
            log.error((Object)error);
            throw new RuntimeException(error);
        }
    }
}

