/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.ai.handler;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.rag.AugmentationRequest;
import dev.langchain4j.rag.AugmentationResult;
import dev.langchain4j.rag.DefaultRetrievalAugmentor;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.AiServiceTokenStream;
import dev.langchain4j.service.TokenStream;
import dev.langchain4j.service.output.ServiceOutputParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.jeecg.ai.assistant.AiStreamChatAssistant;
import org.jeecg.ai.factory.AiModelFactory;
import org.jeecg.ai.factory.AiModelOptions;
import org.jeecg.ai.handler.AIParams;
import org.jeecg.ai.prop.AiChatProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMHandler {
    private static final Logger log = LoggerFactory.getLogger(LLMHandler.class);
    private AiChatProperties aiChatProperties;
    private final ServiceOutputParser serviceOutputParser = new ServiceOutputParser();

    public LLMHandler(AiChatProperties aiChatProperties) {
        this.aiChatProperties = aiChatProperties;
    }

    public LLMHandler() {
    }

    private AIParams ensureParams(AIParams params) {
        if (null == params || StringUtils.isEmpty((String)params.getBaseUrl())) {
            params = this.getDefaultModel(params);
        }
        if (null == params) {
            throw new IllegalArgumentException("\u5927\u8bed\u8a00\u6a21\u578b\u53c2\u6570\u4e3a\u7a7a");
        }
        return params;
    }

    private AIParams getDefaultModel(AIParams params) {
        if (null == this.aiChatProperties) {
            log.warn("\u672a\u914d\u7f6e\u9ed8\u8ba4\u5927\u9884\u8a00\u6a21\u578b");
            return null;
        }
        if (params == null) {
            params = new AIParams();
        }
        params.setProvider(this.aiChatProperties.getProvider());
        params.setModelName(this.aiChatProperties.getModel());
        params.setBaseUrl(this.aiChatProperties.getApiHost());
        params.setApiKey(this.aiChatProperties.getApiKey());
        params.setSecretKey(this.aiChatProperties.getCredential().getSecretKey());
        return params;
    }

    public String completions(String message) {
        return this.completions(Collections.singletonList(UserMessage.from((String)message)), null);
    }

    public String completions(List<ChatMessage> messages, AIParams params) {
        params = this.ensureParams(params);
        AiModelOptions modelOp = params.toModelOptions();
        ChatLanguageModel chatModel = AiModelFactory.createChatModel(modelOp);
        CollateMsgResp chatMessage = this.collateMessage(messages, params);
        log.info("[LLMHandler] send message to AI server. message: {}", (Object)chatMessage);
        Response response = chatModel.generate(chatMessage.chatMemory.messages());
        String resp = (String)this.serviceOutputParser.parse(response, String.class);
        log.info("[LLMHandler] Received the AI's response . message: {}", (Object)resp);
        return resp;
    }

    public TokenStream chat(List<ChatMessage> messages, AIParams params) {
        if (null == (params = this.ensureParams(params))) {
            throw new IllegalArgumentException("\u5927\u8bed\u8a00\u6a21\u578b\u53c2\u6570\u4e3a\u7a7a");
        }
        AiModelOptions modelOp = params.toModelOptions();
        StreamingChatLanguageModel streamingChatModel = AiModelFactory.createStreamingChatModel(modelOp);
        CollateMsgResp chatMessage = this.collateMessage(messages, params);
        AiServiceContext context = new AiServiceContext(AiStreamChatAssistant.class);
        context.streamingChatModel = streamingChatModel;
        log.info("[LLMHandler] send message to AI server. message: {}", (Object)chatMessage);
        return new AiServiceTokenStream(chatMessage.chatMemory.messages(), null, null, chatMessage.augmentationResult != null ? chatMessage.augmentationResult.contents() : null, context, (Object)"default");
    }

    private CollateMsgResp collateMessage(List<ChatMessage> messages, AIParams params) {
        DefaultRetrievalAugmentor retrievalAugmentor;
        if (null == params) {
            params = new AIParams();
        }
        ArrayList<ChatMessage> messagesCopy = new ArrayList<ChatMessage>(messages);
        UserMessage userMessage = null;
        ChatMessage lastMessage = (ChatMessage)messagesCopy.get(messagesCopy.size() - 1);
        if (!lastMessage.type().equals((Object)ChatMessageType.USER)) {
            throw new IllegalArgumentException("\u6700\u540e\u4e00\u6761\u6d88\u606f\u5fc5\u987b\u662f\u7528\u6237\u6d88\u606f");
        }
        userMessage = (UserMessage)messagesCopy.remove(messagesCopy.size() - 1);
        int maxMsgNumber = 6;
        if (null != params.getMaxMsgNumber()) {
            maxMsgNumber = params.getMaxMsgNumber() + 2;
        }
        AtomicReference systemMessageAto = new AtomicReference();
        messagesCopy.removeIf(tempMsg -> {
            if (ChatMessageType.SYSTEM.equals((Object)tempMsg.type())) {
                if (systemMessageAto.get() == null) {
                    systemMessageAto.set((SystemMessage)tempMsg);
                } else {
                    SystemMessage systemMessage = (SystemMessage)systemMessageAto.get();
                    String text = systemMessage.text() + "\n" + ((SystemMessage)tempMsg).text();
                    systemMessageAto.set(SystemMessage.from((String)text));
                }
                return true;
            }
            return false;
        });
        MessageWindowChatMemory chatMemory = MessageWindowChatMemory.builder().maxMessages(Integer.valueOf(maxMsgNumber)).build();
        if (null != systemMessageAto.get()) {
            chatMemory.add((ChatMessage)systemMessageAto.get());
        }
        messagesCopy.forEach(arg_0 -> ((ChatMemory)chatMemory).add(arg_0));
        AugmentationResult augmentationResult = null;
        if (null != params.getQueryRouter() && (retrievalAugmentor = DefaultRetrievalAugmentor.builder().queryRouter(params.getQueryRouter()).build()) != null) {
            StringBuilder userQuestion = new StringBuilder();
            ArrayList<TextContent> contents = new ArrayList<TextContent>(userMessage.contents());
            for (int i = contents.size() - 1; i >= 0; --i) {
                if (!(contents.get(i) instanceof TextContent)) continue;
                userQuestion.append(((TextContent)contents.remove(i)).text());
                userQuestion.append("\n");
            }
            UserMessage textUserMessage = UserMessage.from((String)userQuestion.toString());
            Metadata metadata = Metadata.from((UserMessage)textUserMessage, (Object)"default", (List)chatMemory.messages());
            AugmentationRequest augmentationRequest = new AugmentationRequest((ChatMessage)textUserMessage, metadata);
            augmentationResult = retrievalAugmentor.augment(augmentationRequest);
            textUserMessage = (UserMessage)augmentationResult.chatMessage();
            contents.add(TextContent.from((String)textUserMessage.singleText()));
            userMessage = UserMessage.from(contents);
        }
        chatMemory.add((ChatMessage)userMessage);
        return new CollateMsgResp((ChatMemory)chatMemory, augmentationResult);
    }

    private static class CollateMsgResp {
        public final ChatMemory chatMemory;
        public final AugmentationResult augmentationResult;

        public CollateMsgResp(ChatMemory chatMemory, AugmentationResult augmentationResult) {
            this.chatMemory = chatMemory;
            this.augmentationResult = augmentationResult;
        }

        public String toString() {
            return "{messages=" + (this.chatMemory != null ? this.chatMemory.messages() : "null") + "}";
        }
    }
}

