/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.imports.sax;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.jeecgframework.poi.excel.entity.enmus.CellValueType;
import org.jeecgframework.poi.excel.entity.sax.SaxReadCellEntity;
import org.jeecgframework.poi.excel.imports.sax.parse.ISaxRowRead;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SheetHandler
extends DefaultHandler {
    private SharedStringsTable sst;
    private String lastContents;
    private int curRow = 0;
    private int curCol = 0;
    private CellValueType type;
    private ISaxRowRead read;
    private List<SaxReadCellEntity> rowlist = Lists.newArrayList();

    public SheetHandler(SharedStringsTable sst, ISaxRowRead rowRead) {
        this.sst = sst;
        this.read = rowRead;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.lastContents = "";
        if ("c".equals(name)) {
            String cellType = attributes.getValue("t");
            if ("s".equals(cellType)) {
                this.type = CellValueType.String;
                return;
            }
            cellType = attributes.getValue("s");
            if ("1".equals(cellType)) {
                this.type = CellValueType.Date;
            } else if ("2".equals(cellType)) {
                this.type = CellValueType.Number;
            }
        } else if ("t".equals(name)) {
            this.type = CellValueType.TElement;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (CellValueType.String.equals((Object)this.type)) {
            try {
                int idx = Integer.parseInt(this.lastContents);
                this.lastContents = new XSSFRichTextString(this.sst.getEntryAt(idx)).toString();
            }
            catch (Exception idx) {
                // empty catch block
            }
        }
        if (CellValueType.TElement.equals((Object)this.type)) {
            String value = this.lastContents.trim();
            this.rowlist.add(this.curCol, new SaxReadCellEntity(CellValueType.String, value));
            ++this.curCol;
            this.type = CellValueType.None;
        } else if ("v".equals(name)) {
            String value = this.lastContents.trim();
            String string = value = value.equals("") ? " " : value;
            if (CellValueType.Date.equals((Object)this.type)) {
                Date date = HSSFDateUtil.getJavaDate((double)Double.valueOf(value));
                this.rowlist.add(this.curCol, new SaxReadCellEntity(CellValueType.Date, date));
            } else if (CellValueType.Number.equals((Object)this.type)) {
                BigDecimal bd = new BigDecimal(value);
                this.rowlist.add(this.curCol, new SaxReadCellEntity(CellValueType.Number, bd));
            } else if (CellValueType.String.equals((Object)this.type)) {
                this.rowlist.add(this.curCol, new SaxReadCellEntity(CellValueType.String, value));
            }
            ++this.curCol;
        } else if (name.equals("row")) {
            this.read.parse(this.curRow, this.rowlist);
            this.rowlist.clear();
            ++this.curRow;
            this.curCol = 0;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastContents = this.lastContents + new String(ch, start, length);
    }
}

