/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.util.Date;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class DateRangeRandomizer
extends AbstractRangeRandomizer<Date> {
    public DateRangeRandomizer(Date min, Date max) {
        super(min, max);
    }

    public DateRangeRandomizer(Date min, Date max, long seed) {
        super(min, max, seed);
    }

    @Deprecated
    public static DateRangeRandomizer aNewDateRangeRandomizer(Date min, Date max) {
        return new DateRangeRandomizer(min, max);
    }

    @Deprecated
    public static DateRangeRandomizer aNewDateRangeRandomizer(Date min, Date max, long seed) {
        return new DateRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((Date)this.min).after((Date)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected Date getDefaultMinValue() {
        return new Date(Long.MIN_VALUE);
    }

    @Override
    protected Date getDefaultMaxValue() {
        return new Date(Long.MAX_VALUE);
    }

    @Override
    public Date getRandomValue() {
        long minDateTime = ((Date)this.min).getTime();
        long maxDateTime = ((Date)this.max).getTime();
        long randomDateTime = (long)this.nextDouble(minDateTime, maxDateTime);
        return new Date(randomDateTime);
    }
}

