/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jeasy.random.randomizers.AbstractRandomizer;

public class EnumRandomizer<E extends Enum<E>>
extends AbstractRandomizer<E> {
    private List<E> enumConstants;

    public EnumRandomizer(Class<E> enumeration) {
        this.enumConstants = Arrays.asList(enumeration.getEnumConstants());
    }

    public EnumRandomizer(Class<E> enumeration, long seed) {
        super(seed);
        this.enumConstants = Arrays.asList(enumeration.getEnumConstants());
    }

    public EnumRandomizer(Class<E> enumeration, E ... excludedValues) throws IllegalArgumentException {
        this.checkExcludedValues(enumeration, (Enum[])excludedValues);
        this.enumConstants = this.getFilteredList(enumeration, (Enum[])excludedValues);
    }

    @Deprecated
    public static <E extends Enum<E>> EnumRandomizer<E> aNewEnumRandomizer(Class<E> enumeration) {
        return new EnumRandomizer<E>(enumeration);
    }

    @Deprecated
    public static <E extends Enum<E>> EnumRandomizer<E> aNewEnumRandomizer(Class<E> enumeration, long seed) {
        return new EnumRandomizer<E>(enumeration, seed);
    }

    @Deprecated
    public static <E extends Enum<E>> EnumRandomizer<E> aNewEnumRandomizer(Class<E> enumeration, E ... excludedValues) {
        return new EnumRandomizer(enumeration, excludedValues);
    }

    @Override
    public E getRandomValue() {
        if (this.enumConstants.isEmpty()) {
            return null;
        }
        int randomIndex = this.random.nextInt(this.enumConstants.size());
        return (E)((Enum)this.enumConstants.get(randomIndex));
    }

    private void checkExcludedValues(Class<E> enumeration, E[] excludedValues) {
        boolean excludedValuesIncludeAllValues = Arrays.asList(excludedValues).containsAll(Arrays.asList(enumeration.getEnumConstants()));
        if (excludedValuesIncludeAllValues) {
            throw new IllegalArgumentException("No enum element available for random picking.");
        }
    }

    private List<E> getFilteredList(Class<E> enumeration, E ... excludedValues) {
        ArrayList filteredValues = new ArrayList();
        Collections.addAll(filteredValues, enumeration.getEnumConstants());
        if (excludedValues != null) {
            for (E element : excludedValues) {
                filteredValues.remove(element);
            }
        }
        return filteredValues;
    }
}

