/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jeasy.random.PriorityComparator;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerContext;
import org.jeasy.random.api.RandomizerProvider;
import org.jeasy.random.api.RandomizerRegistry;

class RegistriesRandomizerProvider
implements RandomizerProvider {
    private final List<RandomizerRegistry> registries = new ArrayList<RandomizerRegistry>();
    private final Comparator<Object> priorityComparator = new PriorityComparator();

    RegistriesRandomizerProvider() {
    }

    @Override
    public Randomizer<?> getRandomizerByField(Field field, RandomizerContext context) {
        return this.getRandomizer(new ByFieldProvider(field));
    }

    @Override
    public <T> Randomizer<T> getRandomizerByType(Class<T> type, RandomizerContext context) {
        return this.getRandomizer(new ByTypeProvider(type));
    }

    @Override
    public void setRandomizerRegistries(Set<RandomizerRegistry> randomizerRegistries) {
        this.registries.addAll(randomizerRegistries);
        this.registries.sort(this.priorityComparator);
    }

    private Randomizer<?> getRandomizer(Provider provider) {
        return this.registries.stream().map(provider::getRandomizer).filter(Objects::nonNull).sorted(this.priorityComparator).findFirst().orElse(null);
    }

    private static class ByFieldProvider
    implements Provider {
        private final Field field;

        public ByFieldProvider(Field field) {
            this.field = field;
        }

        @Override
        public Randomizer<?> getRandomizer(RandomizerRegistry registry) {
            return registry.getRandomizer(this.field);
        }
    }

    private static class ByTypeProvider
    implements Provider {
        private final Class<?> type;

        public ByTypeProvider(Class<?> type) {
            this.type = type;
        }

        @Override
        public Randomizer<?> getRandomizer(RandomizerRegistry registry) {
            return registry.getRandomizer(this.type);
        }
    }

    @FunctionalInterface
    private static interface Provider {
        public Randomizer<?> getRandomizer(RandomizerRegistry var1);
    }
}

