/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Random;
import org.jeasy.random.ObjectCreationException;
import org.jeasy.random.api.ObjectFactory;
import org.jeasy.random.api.RandomizerContext;
import org.jeasy.random.util.ReflectionUtils;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ObjenesisObjectFactory
implements ObjectFactory {
    private final Objenesis objenesis = new ObjenesisStd();
    private Random random;

    @Override
    public <T> T createInstance(Class<T> type, RandomizerContext context) {
        if (this.random == null) {
            this.random = new Random(context.getParameters().getSeed());
        }
        if (context.getParameters().isScanClasspathForConcreteTypes() && ReflectionUtils.isAbstract(type)) {
            List<Class<?>> publicConcreteSubTypes = ReflectionUtils.getPublicConcreteSubTypesOf(type);
            if (publicConcreteSubTypes.isEmpty()) {
                throw new InstantiationError("Unable to find a matching concrete subtype of type: " + type + " in the classpath");
            }
            Class<?> randomConcreteSubType = publicConcreteSubTypes.get(this.random.nextInt(publicConcreteSubTypes.size()));
            return (T)this.createNewInstance(randomConcreteSubType);
        }
        try {
            return this.createNewInstance(type);
        }
        catch (Error e) {
            throw new ObjectCreationException("Unable to create an instance of type: " + type, e);
        }
    }

    private <T> T createNewInstance(Class<T> type) {
        try {
            Constructor<T> noArgConstructor = type.getDeclaredConstructor(new Class[0]);
            if (!noArgConstructor.isAccessible()) {
                noArgConstructor.setAccessible(true);
            }
            return noArgConstructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return (T)this.objenesis.newInstance(type);
        }
    }
}

