/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenChannel;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenProducerBase;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.xml.MavenChannelSpecXmlParser;
import org.jboss.galleon.universe.maven.xml.MavenParsedProducerCallbackHandler;
import org.jboss.galleon.universe.maven.xml.MavenProducerXmlParser;
import org.jboss.galleon.universe.maven.xml.ParsedCallbackHandler;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.ZipUtils;

public class MavenProducer
extends MavenProducerBase {
    private final ParsedCallbackHandler<MavenProducerBase, MavenChannel> parsedChannelHandler = new ParsedCallbackHandler<MavenProducerBase, MavenChannel>(){

        @Override
        public MavenProducerBase getParent() {
            return MavenProducer.this;
        }

        @Override
        public void parsed(MavenChannel channel) throws XMLStreamException {
            MavenProducer.this.channels = CollectionUtils.put(MavenProducer.this.channels, (Object)channel.getName(), (Object)channel);
        }
    };
    private Set<String> frequencies = Collections.emptySet();
    private String defaultFrequency;
    private Map<String, MavenChannel> channels = Collections.emptyMap();
    private String defaultChannel;
    private boolean fullyLoaded;
    private boolean resolvedLocally;

    public MavenProducer(String name, MavenRepoManager repoManager, MavenArtifact artifact) throws MavenUniverseException {
        this(name, repoManager, artifact, false);
    }

    public MavenProducer(String name, MavenRepoManager repoManager, MavenArtifact artifact, boolean absoluteLatest) throws MavenUniverseException {
        super(name, repoManager, artifact);
        if (!artifact.isResolved()) {
            this.resolvedLocally = MavenUniverse.resolveUniverseArtifact(repoManager, artifact, !absoluteLatest);
        }
        this.init();
    }

    private void init() throws MavenUniverseException {
        try (FileSystem zipfs = ZipUtils.newFileSystem((Path)this.artifact.getPath());){
            Path producerXml = MavenProducer.getProducerXml(zipfs, this.name);
            if (!Files.exists(producerXml, new LinkOption[0])) {
                throw new MavenUniverseException("Failed to locate " + producerXml + " in " + this.artifact.getCoordsAsString());
            }
            try (BufferedReader reader = Files.newBufferedReader(producerXml);){
                MavenProducerXmlParser.getInstance().parse(reader, new MavenParsedProducerCallbackHandler(){

                    @Override
                    public void parsedName(String name) throws XMLStreamException {
                        if (!name.equals(name)) {
                            throw new XMLStreamException("Parsed producer name " + name + " does not match " + MavenProducer.this.name);
                        }
                    }

                    @Override
                    public void parsedFrequency(String frequency, boolean isDefault) throws XMLStreamException {
                        MavenProducer.this.frequencies = CollectionUtils.add(MavenProducer.this.frequencies, (Object)frequency);
                        if (isDefault) {
                            if (MavenProducer.this.defaultFrequency != null) {
                                throw new XMLStreamException("Failed to set frequency " + frequency + " as the default one, the default frequency has already been set to " + MavenProducer.this.defaultFrequency);
                            }
                            MavenProducer.this.defaultFrequency = frequency;
                        }
                    }

                    @Override
                    public void parsedFpGroupId(String groupId) {
                        MavenProducer.this.fpGroupId = groupId;
                    }

                    @Override
                    public void parsedFpArtifactId(String artifactId) {
                        MavenProducer.this.fpArtifactId = artifactId;
                    }

                    @Override
                    public void parsedDefaultChannel(String channelName) throws XMLStreamException {
                        MavenProducer.this.defaultChannel = channelName;
                    }
                });
            }
            catch (XMLStreamException e) {
                throw new MavenUniverseException("Failed to parse " + producerXml, e);
            }
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to read " + this.artifact.getPath(), e);
        }
        if (this.defaultFrequency == null) {
            this.defaultFrequency = "final";
            if (!this.frequencies.contains(this.defaultFrequency)) {
                this.frequencies = CollectionUtils.add(this.frequencies, (Object)this.defaultFrequency);
            }
        }
    }

    public boolean isResolvedLocally() {
        return this.resolvedLocally;
    }

    public synchronized void refresh() throws MavenUniverseException {
        this.fullyLoaded = false;
        this.channels = Collections.emptyMap();
        this.frequencies = Collections.emptySet();
        this.defaultFrequency = null;
        this.artifact.setPath(null);
        if (this.artifact.getVersionRange() != null) {
            this.repo.resolveLatestVersion(this.artifact, false);
        } else if (this.artifact.hasVersion()) {
            this.repo.resolve(this.artifact);
        } else {
            throw new MavenUniverseException("Producer artifact is missing version and version range: " + this.artifact);
        }
        this.resolvedLocally = false;
        this.init();
    }

    public boolean hasFrequencies() {
        return !this.frequencies.isEmpty();
    }

    @Override
    public Collection<String> getFrequencies() {
        return this.frequencies;
    }

    public boolean hasDefaultFrequency() {
        return this.defaultFrequency != null;
    }

    @Override
    public String getDefaultFrequency() {
        return this.defaultFrequency;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean hasChannel(String name) throws MavenUniverseException {
        if (this.channels.containsKey(name)) {
            return true;
        }
        if (this.fullyLoaded) {
            return false;
        }
        try (FileSystem zipfs = ZipUtils.newFileSystem((Path)this.artifact.getPath());){
            Path channelXml = MavenProducer.getChannelXml(zipfs, this.name, name);
            if (!Files.exists(channelXml, new LinkOption[0])) {
                boolean bl = false;
                return bl;
            }
            try (BufferedReader reader = Files.newBufferedReader(channelXml);){
                MavenChannelSpecXmlParser.getInstance().parse(reader, this.parsedChannelHandler);
                return true;
            }
            catch (IOException | XMLStreamException e) {
                throw new MavenUniverseException("Failed to read " + channelXml, e);
            }
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to read " + this.artifact.getPath(), e);
        }
    }

    public MavenChannel getChannel(String channelName) throws MavenUniverseException {
        if (channelName == null) {
            if (this.defaultChannel != null) {
                channelName = this.defaultChannel;
            } else {
                Collection<MavenChannel> channels = this.getChannels();
                if (channels.size() == 1) {
                    return channels.iterator().next();
                }
                throw new MavenUniverseException(BaseErrors.defaultChannelNotConfigured((String)this.getName()));
            }
        }
        if (!this.hasChannel(channelName)) {
            boolean found = false;
            if (this.resolvedLocally) {
                try {
                    this.refresh();
                }
                catch (MavenUniverseException e) {
                    throw new MavenUniverseException(MavenErrors.msgChannelNotFound(this.name, channelName), (Throwable)((Object)e));
                }
                found = this.hasChannel(channelName);
            }
            if (!found) {
                throw MavenErrors.channelNotFound(this.name, channelName);
            }
        }
        return this.channels.get(channelName);
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized Collection<MavenChannel> getChannels() throws MavenUniverseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasDefaultChannel() {
        return this.defaultChannel != null;
    }

    @Override
    public String getDefaultChannelName() {
        return this.defaultChannel;
    }

    public MavenChannel getDefaultChannel() throws MavenUniverseException {
        if (this.defaultChannel != null) {
            return this.getChannel(this.defaultChannel);
        }
        return null;
    }
}

