/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadChildrenResourcesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-resources", ControllerResolver.getResolver("global")).setParameters(GlobalOperationHandlers.CHILD_TYPE, GlobalOperationHandlers.RECURSIVE, GlobalOperationHandlers.RECURSIVE_DEPTH, GlobalOperationHandlers.PROXIES, GlobalOperationHandlers.INCLUDE_RUNTIME, GlobalOperationHandlers.INCLUDE_DEFAULTS).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).build();
    static final OperationStepHandler INSTANCE = new ReadChildrenResourcesHandler();
    private final ParametersValidator validator = new ParametersValidator();

    public ReadChildrenResourcesHandler() {
        this.validator.registerValidator(GlobalOperationHandlers.CHILD_TYPE.getName(), GlobalOperationHandlers.CHILD_TYPE.getValidator());
        this.validator.registerValidator(GlobalOperationHandlers.RECURSIVE.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(GlobalOperationHandlers.RECURSIVE_DEPTH.getName(), new ModelTypeValidator(ModelType.INT, true));
        this.validator.registerValidator(GlobalOperationHandlers.INCLUDE_RUNTIME.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(GlobalOperationHandlers.PROXIES.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(GlobalOperationHandlers.INCLUDE_DEFAULTS.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String childType = operation.require(GlobalOperationHandlers.CHILD_TYPE.getName()).asString();
        HashMap<PathElement, ModelNode> resources = new HashMap<PathElement, ModelNode>();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Map<String, Set<String>> childAddresses = GlobalOperationHandlers.getChildAddresses(context, address, registry, resource, childType);
        Set<String> childNames = childAddresses.get(childType);
        if (childNames == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownChildType(childType)));
        }
        ReadChildrenResourcesAssemblyHandler assemblyHandler = new ReadChildrenResourcesAssemblyHandler(resources);
        context.addStep(assemblyHandler, OperationContext.Stage.IMMEDIATE);
        for (String key : childNames) {
            PathElement childPath = PathElement.pathElement(childType, key);
            PathAddress childAddress = PathAddress.EMPTY_ADDRESS.append(PathElement.pathElement(childType, key));
            ModelNode readOp = new ModelNode();
            readOp.get("operation").set("read-resource");
            readOp.get("address").set(PathAddress.pathAddress(address, childPath).toModelNode());
            GlobalOperationHandlers.INCLUDE_RUNTIME.validateAndSet(operation, readOp);
            GlobalOperationHandlers.RECURSIVE.validateAndSet(operation, readOp);
            GlobalOperationHandlers.RECURSIVE_DEPTH.validateAndSet(operation, readOp);
            GlobalOperationHandlers.PROXIES.validateAndSet(operation, readOp);
            GlobalOperationHandlers.INCLUDE_DEFAULTS.validateAndSet(operation, readOp);
            OperationStepHandler handler = context.getResourceRegistration().getOperationHandler(childAddress, "read-resource");
            if (handler == null) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.noOperationHandler()));
            }
            ModelNode rrRsp = new ModelNode();
            resources.put(childPath, rrRsp);
            context.addStep(rrRsp, readOp, handler, OperationContext.Stage.IMMEDIATE);
        }
        context.stepCompleted();
    }

    private static class ReadChildrenResourcesAssemblyHandler
    implements OperationStepHandler {
        private final Map<PathElement, ModelNode> resources;

        public ReadChildrenResourcesAssemblyHandler(Map<PathElement, ModelNode> resources) {
            this.resources = resources;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    TreeMap<String, ModelNode> sortedChildren = new TreeMap<String, ModelNode>();
                    boolean failed = false;
                    for (Map.Entry entry : ReadChildrenResourcesAssemblyHandler.this.resources.entrySet()) {
                        PathElement path = (PathElement)entry.getKey();
                        ModelNode value = (ModelNode)entry.getValue();
                        if (!value.has("failure-description")) {
                            sortedChildren.put(path.getValue(), value.get("result"));
                            continue;
                        }
                        if (failed || !value.hasDefined("failure-description")) continue;
                        context.getFailureDescription().set(value.get("failure-description"));
                        failed = true;
                    }
                    if (!failed) {
                        ModelNode result = context.getResult();
                        result.setEmptyObject();
                        for (Map.Entry entry : sortedChildren.entrySet()) {
                            result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                        }
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.VERIFY);
            context.stepCompleted();
        }
    }
}

