/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.CommonAttributes;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;

public class JGroupsSubsystemXMLReader_1_0
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode subsystemAddress = new ModelNode();
        subsystemAddress.add("subsystem", "jgroups");
        subsystemAddress.protect();
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)subsystemAddress);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_STACK: {
                    CommonAttributes.DEFAULT_STACK.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!subsystem.hasDefined("default-stack")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEFAULT_STACK));
        }
        operations.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case JGROUPS_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case STACK: {
                            this.parseStack(reader, subsystemAddress, operations);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStack(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode stack = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        String name = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        ModelNode stackAddress = subsystemAddress.clone();
        stackAddress.add("stack", name);
        stackAddress.protect();
        stack.get("address").set(stackAddress);
        if (!reader.hasNext() || reader.nextTag() == 2 || Element.forName(reader.getLocalName()) != Element.TRANSPORT) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.TRANSPORT));
        }
        this.parseTransport(reader, stackAddress, additionalConfigurationOperations);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROTOCOL: {
                    this.parseProtocol(reader, stackAddress, additionalConfigurationOperations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(stack);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ModelNode stackAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode transportAddress = stackAddress.clone();
        transportAddress.add("transport", "TRANSPORT");
        transportAddress.protect();
        ModelNode transport = Util.getEmptyOperation((String)"add", (ModelNode)transportAddress);
        block18: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        TP.class.getClassLoader().loadClass("org.jgroups.protocols." + value).asSubclass(TP.class).newInstance();
                        CommonAttributes.TYPE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                        continue block18;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SHARED: {
                    CommonAttributes.SHARED.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case SOCKET_BINDING: {
                    CommonAttributes.SOCKET_BINDING.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    CommonAttributes.DIAGNOSTICS_SOCKET_BINDING.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case DEFAULT_EXECUTOR: {
                    CommonAttributes.DEFAULT_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case OOB_EXECUTOR: {
                    CommonAttributes.OOB_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case TIMER_EXECUTOR: {
                    CommonAttributes.TIMER_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case THREAD_FACTORY: {
                    CommonAttributes.THREAD_FACTORY.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case SITE: {
                    CommonAttributes.SITE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case RACK: {
                    CommonAttributes.RACK.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case MACHINE: {
                    CommonAttributes.MACHINE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!transport.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            int attributes = reader.getAttributeCount();
            String property = null;
            block20: for (int i = 0; i < attributes; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        property = value;
                        continue block20;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (property == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            String value = reader.getElementText();
            transport.get("properties").add(property, value);
        }
        operations.add(transport);
    }

    private void parseProtocol(XMLExtendedStreamReader reader, ModelNode stackAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode protocol = Util.getEmptyOperation((String)"add-protocol", null);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        Protocol.class.getClassLoader().loadClass("org.jgroups.protocols." + value).asSubclass(Protocol.class).newInstance();
                        CommonAttributes.TYPE.parseAndSetParameter(value, protocol, (XMLStreamReader)reader);
                        continue block9;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SOCKET_BINDING: {
                    CommonAttributes.SOCKET_BINDING.parseAndSetParameter(value, protocol, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!protocol.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        protocol.get("address").set(stackAddress);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            int attributes = reader.getAttributeCount();
            String property = null;
            block11: for (int i = 0; i < attributes; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        property = value;
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (property == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            String value = reader.getElementText();
            protocol.get("properties").add(property, value);
        }
        operations.add(protocol);
    }
}

