/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.binary.handler.SeleniumServerBinaryHandler;
import org.jboss.arquillian.drone.webdriver.binary.process.StartSeleniumServer;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.ChromeDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.InitializationParameter;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.InitializationParametersMap;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.PersistReusedSessionsEvent;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriver;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusableRemoteWebDriverToDestroy;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSession;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.ReusedSessionStore;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.UnableReuseSessionException;
import org.jboss.arquillian.drone.webdriver.utils.UrlUtils;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class RemoteWebDriverFactory
extends AbstractWebDriverFactory<RemoteWebDriver>
implements Configurator<RemoteWebDriver, WebDriverConfiguration>,
Instantiator<RemoteWebDriver, WebDriverConfiguration>,
Destructor<RemoteWebDriver> {
    private static final Logger log = Logger.getLogger(RemoteWebDriverFactory.class.getName());
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Remote().getReadableName();
    @Inject
    private Instance<ReusedSessionStore> sessionStore;
    @Inject
    private Instance<InitializationParametersMap> initParams;
    @Inject
    private Event<PersistReusedSessionsEvent> persistEvent;
    @Inject
    private Event<StartSeleniumServer> startSeleniumServerEvent;
    @Inject
    @ApplicationScoped
    private InstanceProducer<ReusableRemoteWebDriverToDestroy> lastRemoteWebDriverToDestroy;

    public int getPrecedence() {
        return 0;
    }

    public RemoteWebDriver createInstance(WebDriverConfiguration configuration) {
        URL remoteAddress = configuration.getRemoteAddress();
        if (Validate.empty(remoteAddress)) {
            remoteAddress = WebDriverConfiguration.DEFAULT_REMOTE_URL;
            log.log(Level.INFO, "Property \"remoteAddress\" was not specified, using default value of {0}", WebDriverConfiguration.DEFAULT_REMOTE_URL);
        }
        Validate.isValidUrl(remoteAddress, "Remote address must be a valid url, " + remoteAddress);
        String browser = configuration.getBrowser().toLowerCase();
        if (Validate.empty(browser)) {
            configuration.setBrowser(WebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
            log.log(Level.INFO, "Property \"browser\" was not specified, using default value of {0}", WebDriverConfiguration.DEFAULT_BROWSER_CAPABILITIES);
        }
        Validate.isEmpty(configuration.getBrowser(), "The browser is not set.");
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(this.getCapabilities(configuration, true));
        if (browser.equals("chrome") || browser.equals("chromeheadless")) {
            new ChromeDriverFactory().setChromeOptions(configuration, desiredCapabilities);
        }
        if (!UrlUtils.isReachable(remoteAddress)) {
            if (UrlUtils.isLocalhost(remoteAddress)) {
                log.info("The Selenium server is not running on: " + remoteAddress + " and as the address seems to be a localhost address, Drone will start the Selenium Server automatically.");
                try {
                    this.downloadAndStartSeleniumServer(configuration, browser, remoteAddress);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Something bad happened when Drone was trying to download and extract Selenium Server binary. For more information see the cause.", e);
                }
            } else {
                log.warning("The URL: " + remoteAddress + " doesn't seem to be reachable. If there is no Selenium Server running, start it before the tests are run.");
            }
        }
        RemoteWebDriver driver = null;
        driver = configuration.isRemoteReusable() ? this.createReusableDriver(remoteAddress, (Capabilities)desiredCapabilities) : this.createRemoteDriver(remoteAddress, (Capabilities)desiredCapabilities);
        ((MutableCapabilities)driver.getCapabilities()).setCapability("droneAugmented", (Object)driver);
        if (!configuration.isReuseCookies()) {
            driver.manage().deleteAllCookies();
        }
        return driver;
    }

    private void downloadAndStartSeleniumServer(WebDriverConfiguration configuration, String browser, URL remoteAddress) throws Exception {
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(this.getCapabilities(configuration, true));
        String seleniumServer = new SeleniumServerBinaryHandler(desiredCapabilities).downloadAndPrepare().toString();
        if (!Validate.empty(seleniumServer)) {
            String seleniumServerArgs = configuration.getSeleniumServerArgs();
            if (Validate.empty(seleniumServerArgs)) {
                configuration.setSeleniumServerArgs("");
            }
            this.startSeleniumServerEvent.fire((Object)new StartSeleniumServer(seleniumServer, browser, desiredCapabilities, remoteAddress, seleniumServerArgs));
        }
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        return configuration.getCapabilities();
    }

    public void destroyInstance(RemoteWebDriver driver) {
        if (driver.getSessionId() == null) {
            try {
                driver.quit();
            }
            catch (WebDriverException e) {
                log.log(Level.WARNING, "@Drone {0} has been already destroyed and can't be destroyed again.", driver.getClass().getSimpleName());
            }
            return;
        }
        SessionId sessionId = driver.getSessionId();
        Capabilities driverCapabilities = driver.getCapabilities();
        InitializationParameter param = (InitializationParameter)((InitializationParametersMap)this.initParams.get()).remove(sessionId);
        if (param != null) {
            ReusedSession session = ReusedSession.createInstance(sessionId, driverCapabilities);
            ((ReusedSessionStore)this.sessionStore.get()).store(param, session);
            this.persistEvent.fire((Object)new PersistReusedSessionsEvent());
            this.lastRemoteWebDriverToDestroy.set((Object)new ReusableRemoteWebDriverToDestroy(driver));
        } else {
            driver.quit();
        }
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }

    protected RemoteWebDriver createRemoteDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        return new RemoteWebDriver(remoteAddress, desiredCapabilities);
    }

    private RemoteWebDriver createReusableDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        InitializationParameter initParam = new InitializationParameter(remoteAddress, desiredCapabilities);
        RemoteWebDriver driver = null;
        ReusedSession stored = ((ReusedSessionStore)this.sessionStore.get()).pull(initParam);
        while (stored != null) {
            SessionId reusedSessionId = stored.getSessionId();
            Capabilities reusedCapabilities = stored.getCapabilities();
            try {
                driver = ReusableRemoteWebDriver.fromReusedSession(remoteAddress, reusedCapabilities, reusedSessionId);
                break;
            }
            catch (UnableReuseSessionException ex) {
                log.log(Level.WARNING, "Unable to reuse session: {0}", stored.getSessionId());
                stored = ((ReusedSessionStore)this.sessionStore.get()).pull(initParam);
            }
        }
        if (driver == null) {
            RemoteWebDriver newdriver = this.createRemoteDriver(remoteAddress, desiredCapabilities);
            driver = ReusableRemoteWebDriver.fromRemoteWebDriver(newdriver);
        }
        ((InitializationParametersMap)this.initParams.get()).put(driver.getSessionId(), initParam);
        return driver;
    }
}

