/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.io.File;
import java.util.Map;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.binary.handler.FirefoxDriverBinaryHandler;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.CapabilitiesOptionsMapper;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.jboss.arquillian.drone.webdriver.utils.FirefoxPrefsReader;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxDriverFactory
extends AbstractWebDriverFactory<FirefoxDriver>
implements Configurator<FirefoxDriver, WebDriverConfiguration>,
Instantiator<FirefoxDriver, WebDriverConfiguration>,
Destructor<FirefoxDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Firefox().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(FirefoxDriver instance) {
        instance.quit();
    }

    public FirefoxDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = this.getCapabilities(configuration, true);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, FirefoxDriver.class);
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        DesiredCapabilities capabilities = new DesiredCapabilities(configuration.getCapabilities());
        String binary = (String)capabilities.getCapability("firefox_binary");
        if (Validate.nonEmpty(binary) && performValidations) {
            Validate.isExecutable(binary, "Firefox binary does not point to a valid executable,  " + binary);
        }
        new FirefoxDriverBinaryHandler(capabilities).checkAndSetBinary(performValidations);
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        CapabilitiesOptionsMapper.mapCapabilities(firefoxOptions, capabilities, BROWSER_CAPABILITIES);
        firefoxOptions.addCapabilities((Capabilities)capabilities);
        FirefoxProfile firefoxProfile = this.getFirefoxProfile(capabilities, performValidations);
        if (firefoxProfile != null) {
            firefoxOptions.setProfile(firefoxProfile);
        }
        this.addUserPreferencesFromFile(capabilities, firefoxOptions);
        return firefoxOptions.toCapabilities();
    }

    private FirefoxProfile getFirefoxProfile(DesiredCapabilities capabilities, boolean performValidations) {
        FirefoxProfile firefoxProfile;
        String profile = (String)capabilities.getCapability("firefox_profile");
        boolean profileShouldBeSet = false;
        if (Validate.nonEmpty(profile)) {
            if (performValidations) {
                Validate.isValidPath(profile, "Firefox profile does not point to a valid path " + profile);
            }
            firefoxProfile = new FirefoxProfile(new File(profile));
            profileShouldBeSet = true;
        } else {
            firefoxProfile = new FirefoxProfile();
        }
        String firefoxExtensions = (String)capabilities.getCapability("firefoxExtensions");
        for (String extensionPath : StringUtils.tokenize(firefoxExtensions)) {
            firefoxProfile.addExtension(new File(extensionPath));
            profileShouldBeSet = true;
        }
        return profileShouldBeSet ? firefoxProfile : null;
    }

    private void addUserPreferencesFromFile(DesiredCapabilities capabilities, FirefoxOptions firefoxOptions) {
        String userPreferences = (String)capabilities.getCapability("firefoxUserPreferences");
        if (Validate.nonEmpty(userPreferences)) {
            Validate.isValidPath(userPreferences, "User preferences does not point to a valid path " + userPreferences);
            for (Map.Entry<String, Object> preference : FirefoxPrefsReader.getPreferences(new File(userPreferences)).entrySet()) {
                String key = preference.getKey();
                Object value = preference.getValue();
                if (value instanceof Boolean) {
                    firefoxOptions.addPreference(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    firefoxOptions.addPreference(key, ((Integer)value).intValue());
                    continue;
                }
                if (!(value instanceof String)) continue;
                firefoxOptions.addPreference(key, (String)value);
            }
        }
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

