/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.embedded;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.jboss.arquillian.container.spi.event.container.AfterDeploy;
import org.jboss.arquillian.container.spi.event.container.BeforeUnDeploy;
import org.jboss.arquillian.container.weld.embedded.CDIConversationID;
import org.jboss.arquillian.container.weld.embedded.CDIRequestMap;
import org.jboss.arquillian.container.weld.embedded.CDISessionMap;
import org.jboss.arquillian.container.weld.embedded.WeldMockConfiguration;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.weld.context.bound.BoundConversationContext;
import org.jboss.weld.context.bound.BoundRequest;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jboss.weld.context.bound.BoundSessionContext;
import org.jboss.weld.context.bound.MutableBoundRequest;
import org.jboss.weld.manager.api.WeldManager;

public class LifecycleHandler {
    @Inject
    @ClassScoped
    private InstanceProducer<CDISessionMap> sessionMap;
    @Inject
    @ClassScoped
    private InstanceProducer<CDIRequestMap> requestMap;
    @Inject
    @ClassScoped
    private InstanceProducer<CDIConversationID> conversationId;
    @Inject
    @ClassScoped
    private InstanceProducer<BoundRequest> boundRequest;
    private boolean enableConversationScope = false;

    public void configure(@Observes WeldMockConfiguration configuration) {
        this.enableConversationScope = configuration.isEnableConversationScope();
    }

    public void createSession(@Observes AfterDeploy event, WeldManager manager) {
        BoundSessionContext sessionContext = (BoundSessionContext)manager.instance().select(BoundSessionContext.class, new Annotation[0]).get();
        CDISessionMap map = new CDISessionMap();
        sessionContext.associate((Object)map);
        sessionContext.activate();
        this.sessionMap.set((Object)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(@Observes BeforeUnDeploy event, WeldManager manager) {
        BoundSessionContext sessionContext = (BoundSessionContext)manager.instance().select(BoundSessionContext.class, new Annotation[0]).get();
        CDISessionMap map = (CDISessionMap)this.sessionMap.get();
        if (map != null) {
            try {
                sessionContext.invalidate();
                sessionContext.deactivate();
            }
            finally {
                sessionContext.dissociate((Object)map);
            }
        }
    }

    public void createRequest(@Observes Before event, WeldManager manager) {
        BoundRequestContext requestContext = (BoundRequestContext)manager.instance().select(BoundRequestContext.class, new Annotation[0]).get();
        CDIRequestMap map = new CDIRequestMap();
        requestContext.associate((Object)map);
        requestContext.activate();
        this.requestMap.set((Object)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyRequest(@Observes After event, WeldManager manager) {
        BoundRequestContext requestContext = (BoundRequestContext)manager.instance().select(BoundRequestContext.class, new Annotation[0]).get();
        CDIRequestMap map = (CDIRequestMap)this.requestMap.get();
        if (map != null) {
            try {
                requestContext.invalidate();
                requestContext.deactivate();
            }
            finally {
                requestContext.dissociate((Object)map);
                map.clear();
            }
        }
    }

    public void createConversation(@Observes(precedence=-1) Before event, WeldManager manager) {
        if (!this.enableConversationScope) {
            return;
        }
        CDIConversationID id = (CDIConversationID)this.conversationId.get();
        if (id == null) {
            id = new CDIConversationID(null);
        }
        MutableBoundRequest request = new MutableBoundRequest((Map)this.requestMap.get(), (Map)this.sessionMap.get());
        this.boundRequest.set((Object)request);
        BoundConversationContext conversationContext = (BoundConversationContext)manager.instance().select(BoundConversationContext.class, new Annotation[0]).get();
        conversationContext.associate((Object)request);
        conversationContext.activate(id.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConversation(@Observes(precedence=1) After event, WeldManager manager) {
        if (!this.enableConversationScope) {
            return;
        }
        BoundConversationContext conversationContext = (BoundConversationContext)manager.instance().select(BoundConversationContext.class, new Annotation[0]).get();
        if (!conversationContext.isActive()) {
            return;
        }
        if (!conversationContext.getCurrentConversation().isTransient()) {
            this.conversationId.set((Object)new CDIConversationID(conversationContext.getCurrentConversation().getId()));
        } else {
            this.conversationId.set((Object)new CDIConversationID(null));
        }
        BoundRequest request = (BoundRequest)this.boundRequest.get();
        try {
            conversationContext.invalidate();
            conversationContext.deactivate();
        }
        finally {
            conversationContext.dissociate((Object)request);
        }
    }
}

