/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.weld.ee.embedded_1_1.mock;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpSession
implements HttpSession {
    private String id;
    private ServletContext servletContext;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean invalid = false;
    private int maxInactiveInterval = 60;
    private int lastAccessedTime = -1;

    public MockHttpSession() {
    }

    public MockHttpSession(String id) {
        this.id = id;
    }

    public MockHttpSession(String id, ServletContext servletContext) {
        this(id);
        this.servletContext = servletContext;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        final Iterator<String> nameIterator = this.attributes.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return nameIterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)nameIterator.next();
            }
        };
    }

    public long getCreationTime() {
        return 0L;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException();
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[0]);
    }

    public void invalidate() {
        this.attributes.clear();
        this.invalid = true;
    }

    public boolean isNew() {
        return false;
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void setMaxInactiveInterval(int seconds) {
        this.maxInactiveInterval = seconds;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void access() {
        this.lastAccessedTime = (int)System.currentTimeMillis();
    }
}

