/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.clock;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.javasimon.clock.Clock;

final class CpuClock
implements Clock {
    private final ThreadMXBean threadMXBean;

    CpuClock() {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        this.threadMXBean = mxBean.isCurrentThreadCpuTimeSupported() ? mxBean : null;
    }

    @Override
    public long nanoTime() {
        if (this.threadMXBean == null) {
            return 0L;
        }
        return this.threadMXBean.getCurrentThreadCpuTime();
    }

    @Override
    public long milliTime() {
        return this.millisForNano(this.nanoTime());
    }

    @Override
    public long millisForNano(long nanos) {
        return nanos / 1000000L;
    }
}

