/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.calltree;

import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.callback.CallbackSkeleton;
import org.javasimon.callback.calltree.CallTree;
import org.javasimon.callback.calltree.CallTreeNode;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.callback.logging.LogTemplates;
import org.javasimon.callback.logging.SLF4JLogTemplate;

public class CallTreeCallback
extends CallbackSkeleton {
    private final ThreadLocal<CallTree> threadCallTree = new ThreadLocal();
    private LogTemplate<Split> callTreeLogTemplate;
    public static final String ATTR_NAME_LAST = "lastCallTree";
    private Long logThreshold;

    public CallTreeCallback() {
        this.initLogThreshold(500L);
    }

    public CallTreeCallback(long threshold) {
        this.initLogThreshold(threshold);
    }

    public CallTreeCallback(LogTemplate<Split> callTreeLogTemplate) {
        this.callTreeLogTemplate = callTreeLogTemplate;
    }

    private void initLogThreshold(Long threshold) {
        this.logThreshold = threshold;
        SLF4JLogTemplate<Split> toLogger = LogTemplates.toSLF4J(this.getClass().getName(), "debug");
        this.callTreeLogTemplate = threshold == null ? toLogger : LogTemplates.whenSplitLongerThanMilliseconds(toLogger, threshold);
    }

    public Long getLogThreshold() {
        return this.logThreshold;
    }

    public void setLogThreshold(Long logThreshold) {
        this.initLogThreshold(logThreshold);
    }

    private CallTree getCallTree() {
        return this.threadCallTree.get();
    }

    private CallTree initCallTree() {
        CallTree callTree = new CallTree(this.logThreshold){

            @Override
            protected void onRootStopwatchStop(CallTreeNode rootNode, Split split) {
                CallTreeCallback.this.onRootStopwatchStop(this, split);
            }
        };
        this.threadCallTree.set(callTree);
        return callTree;
    }

    private void removeCallTree() {
        this.threadCallTree.remove();
    }

    @Override
    public void onStopwatchStart(Split split) {
        CallTree callTree = this.getCallTree();
        if (callTree == null) {
            callTree = this.initCallTree();
        }
        callTree.onStopwatchStart(split);
    }

    @Override
    public void onStopwatchStop(Split split, StopwatchSample sample) {
        this.getCallTree().onStopwatchStop(split);
    }

    public void onRootStopwatchStop(CallTree callTree, Split split) {
        this.callTreeLogTemplate.log(split, callTree);
        if (this.logThreshold != null && split.runningFor() > this.logThreshold) {
            split.getStopwatch().setAttribute(ATTR_NAME_LAST, callTree);
        }
        this.removeCallTree();
    }

    public static CallTree getLastCallTree(Stopwatch stopwatch) {
        return (CallTree)stopwatch.getAttribute(ATTR_NAME_LAST);
    }
}

