/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.util.Collection;
import org.javasimon.AbstractSimon;
import org.javasimon.Manager;
import org.javasimon.Simon;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchSample;
import org.javasimon.clock.Clock;
import org.javasimon.utils.SimonUtils;

final class StopwatchImpl
extends AbstractSimon
implements Stopwatch {
    private long total;
    private long counter;
    private long active;
    private long max;
    private long maxTimestamp;
    private long maxActive;
    private long maxActiveTimestamp;
    private long min = Long.MAX_VALUE;
    private long minTimestamp;
    private long last;
    private double mean;
    private double mean2;

    StopwatchImpl(String name, Manager manager) {
        super(name, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stopwatch addSplit(Split split) {
        if (!this.enabled) {
            return this;
        }
        long splitNs = split.runningFor();
        long nowNanos = this.nanoTimeFromSplit(split, splitNs);
        StopwatchSample sample = null;
        StopwatchImpl stopwatchImpl = this;
        synchronized (stopwatchImpl) {
            this.updateUsagesNanos(nowNanos);
            this.addSplit(splitNs);
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
            this.updateIncrementalSimons(splitNs, nowNanos);
        }
        this.manager.callback().onStopwatchAdd(this, split, sample);
        return this;
    }

    private long nanoTimeFromSplit(Split split, long splitNs) {
        if (split.getStopwatch() != null) {
            return split.getStart() + splitNs;
        }
        return this.manager.nanoTime();
    }

    private void updateIncrementalSimons(long splitNs, long nowNanos) {
        Collection<Simon> simons = this.incrementalSimons();
        if (simons != null) {
            for (Simon simon : simons) {
                StopwatchImpl stopwatch = (StopwatchImpl)simon;
                stopwatch.addSplit(splitNs);
                stopwatch.updateUsagesNanos(nowNanos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Split start() {
        if (!this.enabled) {
            return new Split(this, (Clock)this.manager);
        }
        long nowNanos = this.manager.nanoTime();
        StopwatchImpl stopwatchImpl = this;
        synchronized (stopwatchImpl) {
            this.updateUsagesNanos(nowNanos);
            this.activeStart();
        }
        Split split = new Split(this, this.manager, nowNanos);
        this.manager.callback().onStopwatchStart(split);
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(Split split, long start, long nowNanos, String subSimon) {
        StopwatchSample sample = null;
        StopwatchImpl stopwatchImpl = this;
        synchronized (stopwatchImpl) {
            --this.active;
            this.updateUsagesNanos(nowNanos);
            if (subSimon != null) {
                Stopwatch effectiveStopwatch = this.manager.getStopwatch(this.getName() + "." + subSimon);
                split.setAttribute("effective-stopwatch", effectiveStopwatch);
                effectiveStopwatch.addSplit(split);
                return;
            }
            long splitNs = nowNanos - start;
            this.addSplit(splitNs);
            if (!this.manager.callback().callbacks().isEmpty()) {
                sample = this.sample();
            }
            this.updateIncrementalSimons(splitNs, nowNanos);
        }
        this.manager.callback().onStopwatchStop(split, sample);
    }

    private void activeStart() {
        ++this.active;
        if (this.active >= this.maxActive) {
            this.maxActive = this.active;
            this.maxActiveTimestamp = this.getLastUsage();
        }
    }

    private long addSplit(long split) {
        this.last = split;
        this.total += split;
        ++this.counter;
        if (split > this.max) {
            this.max = split;
            this.maxTimestamp = this.getLastUsage();
        }
        if (split < this.min) {
            this.min = split;
            this.minTimestamp = this.getLastUsage();
        }
        double delta = (double)split - this.mean;
        this.mean = (double)this.total / (double)this.counter;
        this.mean2 += delta * ((double)split - this.mean);
        return split;
    }

    @Override
    public synchronized double getMean() {
        return this.mean;
    }

    @Override
    public synchronized double getVarianceN() {
        if (this.counter == 0L) {
            return Double.NaN;
        }
        if (this.counter == 1L) {
            return 0.0;
        }
        return this.mean2 / (double)this.counter;
    }

    @Override
    public synchronized double getVariance() {
        if (this.counter == 0L) {
            return Double.NaN;
        }
        if (this.counter == 1L) {
            return 0.0;
        }
        return this.mean2 / (double)(this.counter - 1L);
    }

    @Override
    public synchronized double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public synchronized long getTotal() {
        return this.total;
    }

    @Override
    public synchronized long getLast() {
        return this.last;
    }

    @Override
    public synchronized long getCounter() {
        return this.counter;
    }

    @Override
    public synchronized long getMax() {
        return this.max;
    }

    @Override
    public synchronized long getMin() {
        return this.min;
    }

    @Override
    public synchronized long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    @Override
    public synchronized long getMinTimestamp() {
        return this.minTimestamp;
    }

    @Override
    public synchronized long getActive() {
        return this.active;
    }

    @Override
    public synchronized long getMaxActive() {
        return this.maxActive;
    }

    @Override
    public synchronized long getMaxActiveTimestamp() {
        return this.maxActiveTimestamp;
    }

    @Override
    void concreteReset() {
        this.total = 0L;
        this.counter = 0L;
        this.max = 0L;
        this.min = Long.MAX_VALUE;
        this.maxTimestamp = 0L;
        this.minTimestamp = 0L;
        this.maxActive = this.active;
        this.maxActiveTimestamp = 0L;
        this.mean = 0.0;
        this.mean2 = 0.0;
    }

    @Override
    @Deprecated
    public synchronized StopwatchSample sampleAndReset() {
        StopwatchSample sample = this.sample();
        this.reset();
        return sample;
    }

    @Override
    public synchronized StopwatchSample sample() {
        StopwatchSample sample = new StopwatchSample();
        sample.setTotal(this.total);
        sample.setCounter(this.counter);
        sample.setMin(this.min);
        sample.setMax(this.max);
        sample.setMinTimestamp(this.minTimestamp);
        sample.setMaxTimestamp(this.maxTimestamp);
        sample.setActive(this.active);
        sample.setMaxActive(this.maxActive);
        sample.setMaxActiveTimestamp(this.maxActiveTimestamp);
        sample.setMean(this.mean);
        sample.setVariance(this.getVariance());
        sample.setVarianceN(this.getVarianceN());
        sample.setStandardDeviation(this.getStandardDeviation());
        sample.setLast(this.last);
        this.sampleCommon(sample);
        return sample;
    }

    @Override
    public synchronized StopwatchSample sampleIncrement(Object key) {
        return (StopwatchSample)this.sampleIncrementHelper(key, new StopwatchImpl(null, this.manager));
    }

    private void updateUsagesNanos(long nowNanos) {
        this.updateUsages(this.manager.millisForNano(nowNanos));
    }

    @Override
    public synchronized String toString() {
        return "Simon Stopwatch: total " + SimonUtils.presentNanoTime(this.total) + ", counter " + this.counter + ", max " + SimonUtils.presentNanoTime(this.max) + ", min " + SimonUtils.presentNanoTime(this.min) + ", mean " + SimonUtils.presentNanoTime((long)this.mean) + super.toString();
    }
}

