/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import org.javasimon.Simon;
import org.javasimon.SimonManager;
import org.javasimon.console.Action;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonType;
import org.javasimon.console.SimonVisitor;
import org.javasimon.console.SimonVisitors;

public class ResetAction
extends Action {
    public static final String PATH = "/data/reset";
    private String pattern;
    private Set<SimonType> types;
    private String name;

    public ResetAction(ActionContext context) {
        super(context);
    }

    @Override
    public void readParameters() {
        this.pattern = this.getContext().getParameterAsString("pattern", null);
        this.name = this.getContext().getParameterAsString("name", null);
        this.types = this.getContext().getParametersAsEnums("type", SimonType.class, null);
    }

    @Override
    public void execute() throws ServletException, IOException, ActionException {
        SimonVisitorImpl visitor = new SimonVisitorImpl();
        if (this.name != null) {
            Simon simon = SimonManager.getSimon((String)this.name);
            if (simon == null) {
                throw new ActionException("Simon \"" + this.name + "\" not found");
            }
            visitor.visit(simon);
        } else {
            SimonVisitors.visitList(this.getContext().getManager(), this.pattern, this.types, visitor);
        }
        this.getContext().getWriter().print("{count:" + visitor.getCount() + "}");
    }

    private static class SimonVisitorImpl
    implements SimonVisitor {
        private int count;

        private SimonVisitorImpl() {
        }

        @Override
        public void visit(Simon simon) throws IOException {
            simon.reset();
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }
}

