/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.javasimon.Sample;
import org.javasimon.Simon;
import org.javasimon.console.SimonType;

public class SimonTypeFactory {
    private static final Map<Class, SimonType> SIMON_TYPE_CACHE = new HashMap<Class, SimonType>();
    private static final SimonTypeMatcher<Simon> TYPE_MATCHER = new SimonTypeMatcher<Simon>(){

        @Override
        public boolean matches(Class<? extends Simon> type, SimonType simonType) {
            return simonType.getType().isAssignableFrom(type);
        }
    };
    private static final SimonTypeMatcher<Sample> SAMPLE_TYPE_MATCHER = new SimonTypeMatcher<Sample>(){

        @Override
        public boolean matches(Class<? extends Sample> type, SimonType simonType) {
            return simonType.getSampleType().isAssignableFrom(type);
        }
    };

    private static <T> SimonType getValue(Class<? extends T> type, SimonTypeMatcher<T> typeMatcher) {
        SimonType simonType = SIMON_TYPE_CACHE.get(type);
        if (simonType == null) {
            for (SimonType lSimonType : SimonType.values()) {
                if (!typeMatcher.matches(type, lSimonType)) continue;
                simonType = lSimonType;
                if (Proxy.isProxyClass(type)) break;
                SIMON_TYPE_CACHE.put(type, simonType);
                break;
            }
        }
        return simonType;
    }

    public static SimonType getValueFromType(Class<? extends Simon> type) {
        return SimonTypeFactory.getValue(type, TYPE_MATCHER);
    }

    public static SimonType getValueFromSampleType(Class<? extends Sample> sampleType) {
        return SimonTypeFactory.getValue(sampleType, SAMPLE_TYPE_MATCHER);
    }

    public static SimonType getValueFromInstance(Simon simon) {
        return simon == null ? null : SimonTypeFactory.getValueFromType(simon.getClass());
    }

    public static SimonType getValueFromInstance(Sample sample) {
        return sample == null ? null : SimonTypeFactory.getValueFromSampleType(sample.getClass());
    }

    public static Class normalizeType(Class type) {
        SimonType simonType = SimonTypeFactory.getValueFromType((Class<? extends Simon>)type);
        Class<? extends Sample> normalizedType = simonType == null ? ((simonType = SimonTypeFactory.getValueFromSampleType(type)) == null ? type : simonType.getSampleType()) : simonType.getType();
        return normalizedType;
    }

    private static interface SimonTypeMatcher<T> {
        public boolean matches(Class<? extends T> var1, SimonType var2);
    }
}

