/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.KeyVisitor;

public final class FileCacheKey
implements IndexScopedKey {
    private final String indexName;
    private final String fileName;
    private final int affinitySegmentId;
    private final int hashCode;

    public FileCacheKey(String indexName, String fileName, int affinitySegmentId) {
        if (fileName == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.indexName = indexName;
        this.fileName = fileName;
        this.affinitySegmentId = affinitySegmentId;
        this.hashCode = this.generatedHashCode();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public int getAffinitySegmentId() {
        return this.affinitySegmentId;
    }

    public Object accept(KeyVisitor visitor) throws Exception {
        return visitor.visit(this);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileCacheKey.class != obj.getClass()) {
            return false;
        }
        FileCacheKey other = (FileCacheKey)obj;
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "M|" + this.fileName + "|" + this.indexName + "|" + this.affinitySegmentId;
    }

    public static final class Externalizer
    extends AbstractExternalizer<FileCacheKey> {
        public void writeObject(ObjectOutput output, FileCacheKey key) throws IOException {
            output.writeUTF(key.indexName);
            output.writeUTF(key.fileName);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)key.affinitySegmentId);
        }

        public FileCacheKey readObject(ObjectInput input) throws IOException {
            String indexName = input.readUTF();
            String fileName = input.readUTF();
            int affinitySegmentId = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            return new FileCacheKey(indexName, fileName, affinitySegmentId);
        }

        public Integer getId() {
            return ExternalizerIds.FILE_CACHE_KEY;
        }

        public Set<Class<? extends FileCacheKey>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{FileCacheKey.class});
        }
    }
}

