/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.KeyVisitor;

public final class ChunkCacheKey
implements IndexScopedKey {
    private final int chunkId;
    private final String indexName;
    private final String fileName;
    private final int bufferSize;
    private final int hashCode;
    private final int affinitySegmentId;

    public ChunkCacheKey(String indexName, String fileName, int chunkId, int bufferSize, int affinitySegmentId) {
        if (fileName == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.indexName = indexName;
        this.fileName = fileName;
        this.chunkId = chunkId;
        this.bufferSize = bufferSize;
        this.affinitySegmentId = affinitySegmentId;
        this.hashCode = this.generatedHashCode();
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public int getAffinitySegmentId() {
        return this.affinitySegmentId;
    }

    public Object accept(KeyVisitor visitor) throws Exception {
        return visitor.visit(this);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.chunkId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ChunkCacheKey.class != obj.getClass()) {
            return false;
        }
        ChunkCacheKey other = (ChunkCacheKey)obj;
        if (this.chunkId != other.chunkId) {
            return false;
        }
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "C|" + this.fileName + "|" + this.chunkId + "|" + this.bufferSize + "|" + this.indexName + "|" + this.affinitySegmentId;
    }

    public static final class Externalizer
    extends AbstractExternalizer<ChunkCacheKey> {
        public void writeObject(ObjectOutput output, ChunkCacheKey key) throws IOException {
            output.writeUTF(key.indexName);
            output.writeUTF(key.fileName);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)key.chunkId);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)key.bufferSize);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)key.affinitySegmentId);
        }

        public ChunkCacheKey readObject(ObjectInput input) throws IOException {
            String indexName = input.readUTF();
            String fileName = input.readUTF();
            int chunkId = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            int bufferSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            int affinitySegmentId = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            return new ChunkCacheKey(indexName, fileName, chunkId, bufferSize, affinitySegmentId);
        }

        public Integer getId() {
            return ExternalizerIds.CHUNK_CACHE_KEY;
        }

        public Set<Class<? extends ChunkCacheKey>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{ChunkCacheKey.class});
        }
    }
}

