/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Option;
import org.aesh.command.parser.RequiredOptionException;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CacheAwareCommand;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.completers.SiteCompleter;
import org.infinispan.cli.completers.XSiteStateTransferModeCompleter;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.CacheResource;
import org.infinispan.cli.resources.ContainerResource;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.configuration.cache.XSiteStateTransferMode;

@GroupCommandDefinition(name="site", description="Manages backup sites", activator=ConnectionActivator.class, groupCommands={Status.class, BringOnline.class, TakeOffline.class, PushSiteState.class, CancelPushState.class, CancelReceiveState.class, PushSiteStatus.class, ClearPushStateStatus.class, View.class, Name.class, StateTransferMode.class, IsRelayNode.class, RelayNodes.class})
public class Site
extends CliCommand {
    private static final Supplier<RequiredOptionException> MISSING_CACHE_OR_GLOBAL = () -> Messages.MSG.requiresOneOf("cache", "all-caches");
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    private static void checkMutualExclusiveCacheAndGlobal(String cache, boolean global) {
        if (cache != null && global) {
            throw Messages.MSG.mutuallyExclusiveOptions("cache", "all-caches");
        }
    }

    private static RestCacheManagerClient restCacheManagerClient(RestClient client, Resource resource) {
        return ContainerResource.findContainerName(resource).map(arg_0 -> ((RestClient)client).cacheManager(arg_0)).orElseThrow(Messages.MSG::illegalContext);
    }

    private static RestCacheClient restCacheClient(RestClient client, Resource resource, String cacheName) throws RequiredOptionException {
        return cacheName == null ? CacheResource.findCacheName(resource).map(arg_0 -> ((RestClient)client).cache(arg_0)).orElseThrow(MISSING_CACHE_OR_GLOBAL) : client.cache(cacheName);
    }

    @CommandDefinition(name="is-relay-node", description="Returns true if the node handles relay messages between clusters.", activator=ConnectionActivator.class)
    public static class IsRelayNode
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                Connection connection = invocation.getContext().getConnection();
                connection.refreshServerInfo();
                invocation.println(String.valueOf(connection.isRelayNode()));
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="relay-nodes", description="Returns the list of relay nodes.", activator=ConnectionActivator.class)
    public static class RelayNodes
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                Connection connection = invocation.getContext().getConnection();
                connection.refreshServerInfo();
                invocation.println(String.valueOf(connection.getRelayNodes()));
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="set", description="Sets the cross-site state transfer mode.", activator=ConnectionActivator.class)
    public static class SetStateTransferMode
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;
        @Option(shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=115, required=true, completer=SiteCompleter.class, description="The remote backup name.")
        String site;
        @Option(shortName=109, required=true, completer=XSiteStateTransferModeCompleter.class, description="The state transfer mode to set.")
        protected String mode;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            String cacheName = this.getCacheName(resource).orElseThrow(Messages.MSG::illegalContext);
            return client.cache(cacheName).xSiteStateTransferMode(this.site, XSiteStateTransferMode.valueOf((String)this.mode.toUpperCase()));
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return this.cache == null ? CacheResource.findCacheName(activeResource) : Optional.of(this.cache);
        }
    }

    @CommandDefinition(name="get", description="Retrieves the cross-site state transfer mode.", activator=ConnectionActivator.class)
    public static class GetStateTransferMode
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;
        @Option(shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=115, required=true, completer=SiteCompleter.class, description="The remote backup name.")
        String site;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return this.cache == null ? CacheResource.findCacheName(activeResource) : Optional.of(this.cache);
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            String cacheName = this.getCacheName(resource).orElseThrow(Messages.MSG::illegalContext);
            return client.cache(cacheName).xSiteStateTransferMode(this.site);
        }
    }

    @GroupCommandDefinition(name="state-transfer-mode", description="Controls the cross-site state transfer mode.", activator=ConnectionActivator.class, groupCommands={GetStateTransferMode.class, SetStateTransferMode.class})
    public static class StateTransferMode
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            invocation.println(invocation.getHelpInfo());
            return CommandResult.FAILURE;
        }
    }

    @CommandDefinition(name="name", description="Prints the local site name", activator=ConnectionActivator.class)
    public static class Name
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                Connection connection = invocation.getContext().getConnection();
                connection.refreshServerInfo();
                invocation.println(connection.getLocalSiteName());
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="view", description="Prints the global sites view", activator=ConnectionActivator.class)
    public static class View
    extends CliCommand {
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
            try {
                Connection connection = invocation.getContext().getConnection();
                connection.refreshServerInfo();
                invocation.println(connection.getSitesView().toString());
                return CommandResult.SUCCESS;
            }
            catch (IOException e) {
                throw new CommandException((Throwable)e);
            }
        }
    }

    @CommandDefinition(name="clear-push-site-status", description="Clears the push state status", activator=ConnectionActivator.class)
    public static class ClearPushStateStatus
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(required=true, shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).clearPushStateStatus();
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return Optional.ofNullable(this.cache);
        }
    }

    @CommandDefinition(name="push-site-status", description="Shows the status of pushing to a site", activator=ConnectionActivator.class)
    public static class PushSiteStatus
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(required=true, shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).pushStateStatus();
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return Optional.ofNullable(this.cache);
        }
    }

    @CommandDefinition(name="cancel-receive-state", description="Cancels receiving state to a site", activator=ConnectionActivator.class)
    public static class CancelReceiveState
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(required=true, shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(required=true, shortName=115, completer=SiteCompleter.class, description="The remote backup name.")
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).cancelReceiveState(this.site);
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return Optional.ofNullable(this.cache);
        }
    }

    @CommandDefinition(name="cancel-push-state", description="Cancels pushing state to a site", activator=ConnectionActivator.class)
    public static class CancelPushState
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=97, name="all-caches", hasValue=false, description="Invoke operation in all caches.")
        boolean allCaches;
        @Option(required=true, shortName=115, completer=SiteCompleter.class, description="The remote backup name.")
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) throws RequiredOptionException {
            Site.checkMutualExclusiveCacheAndGlobal(this.cache, this.allCaches);
            return this.allCaches ? Site.restCacheManagerClient(client, resource).cancelPushState(this.site) : Site.restCacheClient(client, resource, this.cache).cancelPushState(this.site);
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return this.cache == null ? CacheResource.findCacheName(activeResource) : Optional.of(this.cache);
        }
    }

    @CommandDefinition(name="push-site-state", description="Starts pushing state to a site", activator=ConnectionActivator.class)
    public static class PushSiteState
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=97, name="all-caches", hasValue=false, description="Invoke operation in all caches.")
        boolean allCaches;
        @Option(required=true, shortName=115, completer=SiteCompleter.class, description="The remote backup name.")
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) throws RequiredOptionException {
            Site.checkMutualExclusiveCacheAndGlobal(this.cache, this.allCaches);
            return this.allCaches ? Site.restCacheManagerClient(client, resource).pushSiteState(this.site) : Site.restCacheClient(client, resource, this.cache).pushSiteState(this.site);
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return this.cache == null ? CacheResource.findCacheName(activeResource) : Optional.of(this.cache);
        }
    }

    @CommandDefinition(name="take-offline", description="Takes a site offline", activator=ConnectionActivator.class)
    public static class TakeOffline
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=97, name="all-caches", hasValue=false, description="Invoke operation in all caches.")
        boolean allCaches;
        @Option(required=true, shortName=115, completer=SiteCompleter.class, description="The remote backup name.")
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) throws RequiredOptionException {
            Site.checkMutualExclusiveCacheAndGlobal(this.cache, this.allCaches);
            return this.allCaches ? Site.restCacheManagerClient(client, resource).takeOffline(this.site) : Site.restCacheClient(client, resource, this.cache).takeSiteOffline(this.site);
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return this.cache == null ? CacheResource.findCacheName(activeResource) : Optional.of(this.cache);
        }
    }

    @CommandDefinition(name="bring-online", description="Brings a site online", activator=ConnectionActivator.class)
    public static class BringOnline
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=97, name="all-caches", hasValue=false, description="Invoke operation in all caches.")
        boolean allCaches;
        @Option(required=true, shortName=115, completer=SiteCompleter.class, description="The remote backup name.")
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) throws RequiredOptionException {
            Site.checkMutualExclusiveCacheAndGlobal(this.cache, this.allCaches);
            return this.allCaches ? Site.restCacheManagerClient(client, resource).bringBackupOnline(this.site) : Site.restCacheClient(client, resource, this.cache).bringSiteOnline(this.site);
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return this.cache == null ? CacheResource.findCacheName(activeResource) : Optional.of(this.cache);
        }
    }

    @CommandDefinition(name="status", description="Shows site status", activator=ConnectionActivator.class)
    public static class Status
    extends RestCliCommand
    implements CacheAwareCommand {
        @Option(shortName=99, completer=CacheCompleter.class, description="The cache name.")
        String cache;
        @Option(shortName=97, name="all-caches", hasValue=false, description="Invoke operation in all caches.")
        boolean allCaches;
        @Option(shortName=115, completer=SiteCompleter.class, description="The remote backup name.")
        String site;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) throws RequiredOptionException {
            Site.checkMutualExclusiveCacheAndGlobal(this.cache, this.allCaches);
            if (this.allCaches) {
                RestCacheManagerClient cm = Site.restCacheManagerClient(client, resource);
                return this.site == null ? cm.backupStatuses() : cm.backupStatus(this.site);
            }
            RestCacheClient c = Site.restCacheClient(client, resource, this.cache);
            return this.site == null ? c.xsiteBackups() : c.backupStatus(this.site);
        }

        @Override
        public Optional<String> getCacheName(Resource activeResource) {
            return this.cache == null ? CacheResource.findCacheName(activeResource) : Optional.of(this.cache);
        }
    }
}

