/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependenciesClassAdapter
extends ClassRemapper {
    private static final DeepVisitor ev = new DeepVisitor();

    static DependenciesClassAdapter readFrom(InputStream input) throws IOException {
        DependenciesClassAdapter v = new DependenciesClassAdapter();
        new ClassReader(input).accept((ClassVisitor)v, 6);
        return v;
    }

    private DependenciesClassAdapter() {
        super((ClassVisitor)ev, (Remapper)new CollectingRemapper());
    }

    String getName() {
        return this.className;
    }

    Set<String> getDependencies() {
        return ((CollectingRemapper)this.remapper).classes;
    }

    private static class DeepVisitor
    extends ClassVisitor {
        private static final AnnotationVisitor av = new AnnotationVisitor(327680){

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return this;
            }

            public AnnotationVisitor visitArray(String name) {
                return this;
            }
        };
        private static final MethodVisitor mv = new MethodVisitor(327680){

            public AnnotationVisitor visitAnnotationDefault() {
                return av;
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return av;
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                return av;
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                return av;
            }
        };
        private static final FieldVisitor fieldVisitor = new FieldVisitor(262144){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return av;
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                return av;
            }
        };

        DeepVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return av;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return fieldVisitor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return mv;
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return av;
        }
    }

    private static class CollectingRemapper
    extends Remapper {
        final Set<String> classes = new HashSet<String>(256);

        private CollectingRemapper() {
        }

        public String map(String className) {
            this.classes.add(className);
            return className;
        }
    }
}

