/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen.utils;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.iherus.codegen.utils.HttpConnectionException;
import org.iherus.codegen.utils.IOUtils;

public class HttpUtils {
    private HttpUtils() {
    }

    public static byte[] readStreamToByteArray(String url) {
        byte[] byArray;
        ByteArrayOutputStream ous;
        InputStream ins;
        HttpURLConnection connection;
        block7: {
            int len;
            connection = null;
            ins = null;
            ous = null;
            URL i = new URL(url);
            connection = (HttpURLConnection)i.openConnection();
            connection.setUseCaches(false);
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            if ("HTTPS".equalsIgnoreCase(i.getProtocol())) {
                HttpUtils.trustHttps(connection);
            }
            if (200 != connection.getResponseCode()) break block7;
            ins = connection.getInputStream();
            ous = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = ins.read(buffer)) != -1) {
                ous.write(buffer, 0, len);
            }
            ous.flush();
            byte[] byArray2 = ous.toByteArray();
            IOUtils.closeQuietly(ous);
            IOUtils.closeQuietly(ins);
            IOUtils.close(connection);
            return byArray2;
        }
        try {
            byArray = new byte[]{};
        }
        catch (Exception e) {
            try {
                throw new HttpConnectionException("Failed to obtain ByteArray by URL.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ous);
                IOUtils.closeQuietly(ins);
                IOUtils.close(connection);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(ous);
        IOUtils.closeQuietly(ins);
        IOUtils.close(connection);
        return byArray;
    }

    private static void trustHttps(URLConnection connection) throws SSLException {
        if (!(connection instanceof HttpsURLConnection)) {
            return;
        }
        HttpsURLConnection conn = (HttpsURLConnection)connection;
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager()};
        try {
            SSLContext sc = SSLContext.getInstance("TLSv1.2");
            sc.init(null, trustManagers, new SecureRandom());
            conn.setSSLSocketFactory(sc.getSocketFactory());
            conn.setHostnameVerifier(new HostnameVerifier());
        }
        catch (Exception e) {
            throw new SSLException("Trusts HttpsURLConnection failed.", e);
        }
    }

    public static final class X509TrustManager
    implements javax.net.ssl.X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    public static final class HostnameVerifier
    implements javax.net.ssl.HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

