/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.codegen;

import com.google.zxing.common.BitMatrix;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import org.iherus.codegen.Codectx;

public abstract class AbstractGenerator {
    public static final Color getColor(String hexColor) {
        String hexc = hexColor;
        Color result = Color.WHITE;
        if (hexc != null && !"".equals(hexc)) {
            if (hexc.startsWith("#")) {
                hexc = hexc.replaceFirst("#", "");
            }
            result = new Color(Integer.parseInt(hexc, 16));
        }
        return result;
    }

    public static BitMatrix redrawBitMatrix(BitMatrix bitMatrix, int padding) {
        int tempPadding = padding * 2;
        int[] attributes = bitMatrix.getEnclosingRectangle();
        int rawWidth = attributes[2] + tempPadding;
        int rawHeight = attributes[3] + tempPadding;
        BitMatrix redrawBM = new BitMatrix(rawWidth, rawHeight);
        redrawBM.clear();
        int left = attributes[0];
        int top = attributes[1];
        for (int x = padding; x < rawWidth - padding; ++x) {
            for (int y = padding; y < rawHeight - padding; ++y) {
                if (!bitMatrix.get(x + left - padding, y + top - padding)) continue;
                redrawBM.set(x, y);
            }
        }
        return redrawBM;
    }

    public static BufferedImage setRadius(BufferedImage image, int radius, int borderSize, String borderColor, Codectx.BorderStyle style, int borderDashGranularity, int margin) {
        int width = image.getWidth();
        int height = image.getHeight();
        int canvasWidth = width + margin * 2;
        int canvasHeight = height + margin * 2;
        BufferedImage canvasImage = new BufferedImage(canvasWidth, canvasHeight, 2);
        Graphics2D graphics = canvasImage.createGraphics();
        graphics.setComposite(AlphaComposite.Src);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(Color.WHITE);
        graphics.fill(new RoundRectangle2D.Float(0.0f, 0.0f, canvasWidth, canvasHeight, radius, radius));
        graphics.setComposite(AlphaComposite.SrcAtop);
        graphics.drawImage((Image)AbstractGenerator.clip(image, radius), margin, margin, null);
        if (borderSize > 0) {
            BasicStroke stroke = Codectx.BorderStyle.SOLID == style ? new BasicStroke(borderSize) : new BasicStroke(borderSize, 0, 1, 10.0f, new float[]{borderDashGranularity, borderDashGranularity}, 0.0f);
            graphics.setColor(AbstractGenerator.getColor(borderColor));
            graphics.setStroke(stroke);
            graphics.drawRoundRect(margin, margin, width - 1, height - 1, radius, radius);
        }
        graphics.dispose();
        image.flush();
        return canvasImage;
    }

    public static BufferedImage clip(BufferedImage image, int radius) {
        int width = image.getWidth();
        int height = image.getHeight();
        int max = Math.max(width, height);
        RectangularShape shape = null;
        shape = max == radius ? new Ellipse2D.Float(0.0f, 0.0f, width, height) : new RoundRectangle2D.Float(0.0f, 0.0f, width, height, radius, radius);
        BufferedImage canvasImage = new BufferedImage(width, height, 2);
        Graphics2D graphics = canvasImage.createGraphics();
        graphics.setClip(shape);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage((Image)image, 0, 0, null);
        graphics.dispose();
        image.flush();
        return canvasImage;
    }
}

