/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.Serializable;
import java.util.Locale;
import org.htmlunit.cssparser.dom.CSSValueImpl;
import org.htmlunit.cssparser.parser.LexicalUnit;
import org.w3c.dom.DOMException;

public class HSLColorImpl
implements Serializable {
    private final String function_;
    private CSSValueImpl hue_;
    private CSSValueImpl saturation_;
    private CSSValueImpl lightness_;
    private CSSValueImpl alpha_;
    private final boolean commaSeparated_;

    public HSLColorImpl(String function, LexicalUnit lu) throws DOMException {
        if (function == null) {
            throw new DOMException(12, "Color space hsl or hsla is required.");
        }
        String functionLC = function.toLowerCase(Locale.ROOT);
        if (!"hsl".equals(functionLC) && !"hsla".equals(functionLC)) {
            throw new DOMException(12, "Color space '" + functionLC + "' not supported.");
        }
        this.function_ = functionLC;
        LexicalUnit next = lu;
        this.hue_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, this.function_ + " requires at least three values.");
        }
        boolean bl = this.commaSeparated_ = next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA;
        if (this.commaSeparated_) {
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, this.function_ + " requires at least three values.");
            }
            if (LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
                throw new DOMException(12, "Saturation part has to be percentage.");
            }
            this.saturation_ = new CSSValueImpl(next, true);
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, this.function_ + " requires at least three values.");
            }
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, this.function_ + " parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, this.function_ + "b requires at least three values.");
            }
            if (LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
                throw new DOMException(12, "Lightness part has to be percentage.");
            }
            this.lightness_ = new CSSValueImpl(next, true);
            if ((next = next.getNextLexicalUnit()) == null) {
                return;
            }
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, this.function_ + " parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Missing alpha value.");
            }
            if (LexicalUnit.LexicalUnitType.INTEGER != next.getLexicalUnitType() && LexicalUnit.LexicalUnitType.REAL != next.getLexicalUnitType() && LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
                throw new DOMException(12, "Alpha part has to be numeric or percentage.");
            }
            this.alpha_ = new CSSValueImpl(next, true);
            if ((next = next.getNextLexicalUnit()) != null) {
                throw new DOMException(12, "Too many parameters for " + this.function_ + " function.");
            }
            return;
        }
        if (LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
            throw new DOMException(12, "Saturation part has to be percentage.");
        }
        this.saturation_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, this.function_ + " requires at least three values.");
        }
        if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            throw new DOMException(12, this.function_ + " requires consitent separators (blank or comma).");
        }
        if (LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
            throw new DOMException(12, "Lightness part has to be percentage.");
        }
        this.lightness_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) == null) {
            return;
        }
        if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_SLASH) {
            throw new DOMException(12, this.function_ + " alpha value must be separated by '/'.");
        }
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, "Missing alpha value.");
        }
        if (LexicalUnit.LexicalUnitType.INTEGER != next.getLexicalUnitType() && LexicalUnit.LexicalUnitType.REAL != next.getLexicalUnitType() && LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
            throw new DOMException(12, "Alpha part has to be numeric or percentage.");
        }
        this.alpha_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) != null) {
            throw new DOMException(12, "Too many parameters for " + this.function_ + " function.");
        }
    }

    public CSSValueImpl getHue() {
        return this.hue_;
    }

    public void setHue(CSSValueImpl hue) {
        this.hue_ = hue;
    }

    public CSSValueImpl getSaturation() {
        return this.saturation_;
    }

    public void setSaturation(CSSValueImpl saturation) {
        this.saturation_ = saturation;
    }

    public CSSValueImpl getLightness() {
        return this.lightness_;
    }

    public void setLightness(CSSValueImpl lightness) {
        this.lightness_ = lightness;
    }

    public CSSValueImpl getAlpha() {
        return this.alpha_;
    }

    public void setAlpha(CSSValueImpl alpha) {
        this.alpha_ = alpha;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.function_).append("(").append(this.hue_);
        if (this.commaSeparated_) {
            sb.append(", ").append(this.saturation_).append(", ").append(this.lightness_);
            if (null != this.alpha_) {
                sb.append(", ").append(this.alpha_);
            }
        } else {
            sb.append(" ").append(this.saturation_).append(" ").append(this.lightness_);
            if (null != this.alpha_) {
                sb.append(" / ").append(this.alpha_);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

