/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.webflux;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.dict.DictDefine;
import org.hswebframework.web.dict.DictDefineRepository;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.dictionary.entity.DictionaryEntity;
import org.hswebframework.web.dictionary.service.DefaultDictionaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/dictionary"})
@Resource(id="dictionary", name="\u6570\u636e\u5b57\u5178")
@Tag(name="\u6570\u636e\u5b57\u5178\u7ba1\u7406")
public class WebfluxDictionaryController
implements ReactiveServiceCrudController<DictionaryEntity, String> {
    @Autowired
    private DefaultDictionaryService dictionaryService;
    @Autowired
    private DictDefineRepository repository;

    public ReactiveCrudService<DictionaryEntity, String> getService() {
        return this.dictionaryService;
    }

    @GetMapping(value={"/detail/_query"})
    @QueryNoPagingOperation(summary="\u4f7f\u7528GET\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5b57\u5178\u8be6\u60c5")
    public Flux<DictionaryEntity> getItemDefineById(@Parameter(hidden=true) QueryParamEntity query) {
        return this.dictionaryService.findAllDetail(query, true);
    }

    @PostMapping(value={"/detail/_query"})
    @Operation(summary="\u4f7f\u7528POST\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5b57\u5178\u8be6\u60c5")
    public Flux<DictionaryEntity> getItemDefineById(@RequestBody Mono<QueryParamEntity> query) {
        return query.flatMapMany(param -> this.dictionaryService.findAllDetail((QueryParamEntity)param, true));
    }

    @GetMapping(value={"/{id:.+}/items"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u6570\u636e\u5b57\u6bb5\u7684\u6240\u6709\u9009\u9879")
    public Flux<EnumDict<?>> getItemDefineById(@PathVariable String id) {
        return this.repository.getDefine(id).flatMapIterable(DictDefine::getItems);
    }

    @GetMapping(value={"/_all"})
    @Authorize(merge=false)
    @Schema(description="\u83b7\u53d6\u5168\u90e8\u6570\u636e\u5b57\u5178")
    public Flux<DictDefine> getAllDict() {
        return this.repository.getAllDefine();
    }
}

