/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.dictionary.configuration;

import org.hswebframework.web.cache.ReactiveCacheManager;
import org.hswebframework.web.dictionary.configuration.DictionaryProperties;
import org.hswebframework.web.dictionary.service.CompositeDictDefineRepository;
import org.hswebframework.web.dictionary.service.DefaultDictionaryItemService;
import org.hswebframework.web.dictionary.service.DefaultDictionaryService;
import org.hswebframework.web.dictionary.webflux.WebfluxDictionaryController;
import org.hswebframework.web.dictionary.webflux.WebfluxDictionaryItemController;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={DictionaryProperties.class})
public class DictionaryAutoConfiguration {

    @AutoConfiguration
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class DictionaryWebFluxConfiguration {
        DictionaryWebFluxConfiguration() {
        }

        @Bean
        public WebfluxDictionaryController webfluxDictionaryController() {
            return new WebfluxDictionaryController();
        }

        @Bean
        public WebfluxDictionaryItemController webfluxDictionaryItemController() {
            return new WebfluxDictionaryItemController();
        }
    }

    @AutoConfiguration
    static class DictionaryServiceConfiguration {
        DictionaryServiceConfiguration() {
        }

        @Bean
        public DefaultDictionaryItemService defaultDictionaryItemService() {
            return new DefaultDictionaryItemService();
        }

        @Bean
        public DefaultDictionaryService defaultDictionaryService() {
            return new DefaultDictionaryService();
        }

        @Bean
        public CompositeDictDefineRepository compositeDictDefineRepository(DictionaryProperties properties, DefaultDictionaryService service, ReactiveCacheManager cacheManager) {
            return new CompositeDictDefineRepository(service, cacheManager, properties);
        }
    }
}

