/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.cfg.spi.DomainDataRegionBuildingContext;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.ehcache.MissingCacheStrategy;
import org.hibernate.cache.ehcache.internal.DeprecationLogger;
import org.hibernate.cache.ehcache.internal.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.HibernateEhcacheUtils;
import org.hibernate.cache.ehcache.internal.StorageAccessImpl;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.SecondLevelCacheLogger;
import org.hibernate.cache.spi.support.DomainDataRegionImpl;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.cache.spi.support.RegionFactoryTemplate;
import org.hibernate.cache.spi.support.RegionNameQualifier;
import org.hibernate.cache.spi.support.StorageAccess;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class EhcacheRegionFactory
extends RegionFactoryTemplate {
    private static final EhCacheMessageLogger LOG = EhCacheMessageLogger.INSTANCE;
    private final CacheKeysFactory cacheKeysFactory;
    private volatile CacheManager cacheManager;
    private volatile MissingCacheStrategy missingCacheStrategy;
    private volatile long cacheLockTimeout;

    public EhcacheRegionFactory() {
        this((CacheKeysFactory)DefaultCacheKeysFactory.INSTANCE);
    }

    public EhcacheRegionFactory(CacheKeysFactory cacheKeysFactory) {
        this.cacheKeysFactory = cacheKeysFactory;
        DeprecationLogger.INSTANCE.logDeprecation();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected CacheKeysFactory getImplicitCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    public DomainDataRegion buildDomainDataRegion(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new DomainDataRegionImpl(regionConfig, (RegionFactoryTemplate)this, this.createDomainDataStorageAccess(regionConfig, buildingContext), this.cacheKeysFactory, buildingContext);
    }

    protected DomainDataStorageAccess createDomainDataStorageAccess(DomainDataRegionConfig regionConfig, DomainDataRegionBuildingContext buildingContext) {
        return new StorageAccessImpl(this.getOrCreateCache(regionConfig.getRegionName(), buildingContext.getSessionFactory()));
    }

    protected StorageAccess createQueryResultsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        String defaultedRegionName = this.defaultRegionName(regionName, sessionFactory, "default-query-results-region", LEGACY_QUERY_RESULTS_REGION_UNQUALIFIED_NAMES);
        return new StorageAccessImpl(this.getOrCreateCache(defaultedRegionName, sessionFactory));
    }

    protected StorageAccess createTimestampsRegionStorageAccess(String regionName, SessionFactoryImplementor sessionFactory) {
        String defaultedRegionName = this.defaultRegionName(regionName, sessionFactory, "default-update-timestamps-region", LEGACY_UPDATE_TIMESTAMPS_REGION_UNQUALIFIED_NAMES);
        return new StorageAccessImpl(this.getOrCreateCache(defaultedRegionName, sessionFactory));
    }

    protected final String defaultRegionName(String regionName, SessionFactoryImplementor sessionFactory, String defaultRegionName, List<String> legacyDefaultRegionNames) {
        if (defaultRegionName.equals(regionName) && !this.cacheExists(regionName, sessionFactory)) {
            for (String legacyDefaultRegionName : legacyDefaultRegionNames) {
                if (!this.cacheExists(legacyDefaultRegionName, sessionFactory)) continue;
                SecondLevelCacheLogger.INSTANCE.usingLegacyCacheName(defaultRegionName, legacyDefaultRegionName);
                return legacyDefaultRegionName;
            }
        }
        return regionName;
    }

    protected Ehcache getOrCreateCache(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        this.verifyStarted();
        assert (!RegionNameQualifier.INSTANCE.isQualified(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions()));
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        Ehcache cache = this.cacheManager.getEhcache(qualifiedRegionName);
        if (cache == null) {
            return this.createCache(qualifiedRegionName);
        }
        return cache;
    }

    protected Ehcache createCache(String regionName) {
        switch (this.missingCacheStrategy) {
            case CREATE_WARN: {
                SecondLevelCacheLogger.INSTANCE.missingCacheCreated(regionName, "hibernate.cache.ehcache.missing_cache_strategy", MissingCacheStrategy.CREATE.getExternalRepresentation());
                this.cacheManager.addCache(regionName);
                return this.cacheManager.getEhcache(regionName);
            }
            case CREATE: {
                this.cacheManager.addCache(regionName);
                return this.cacheManager.getEhcache(regionName);
            }
            case FAIL: {
                throw new CacheException("On-the-fly creation of Ehcache Cache objects is not supported [" + regionName + "]");
            }
        }
        throw new IllegalStateException("Unsupported missing cache strategy: " + (Object)((Object)this.missingCacheStrategy));
    }

    protected boolean cacheExists(String unqualifiedRegionName, SessionFactoryImplementor sessionFactory) {
        String qualifiedRegionName = RegionNameQualifier.INSTANCE.qualify(unqualifiedRegionName, sessionFactory.getSessionFactoryOptions());
        return this.cacheManager.getEhcache(qualifiedRegionName) != null;
    }

    protected boolean isStarted() {
        return super.isStarted() && this.cacheManager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareForUse(SessionFactoryOptions settings, Map configValues) {
        EhcacheRegionFactory ehcacheRegionFactory = this;
        synchronized (ehcacheRegionFactory) {
            this.cacheManager = this.resolveCacheManager(settings, configValues);
            if (this.cacheManager == null) {
                throw new CacheException("Could not start Ehcache CacheManager");
            }
            this.missingCacheStrategy = MissingCacheStrategy.interpretSetting(configValues.get("hibernate.cache.ehcache.missing_cache_strategy"));
            Object cacheLockTimeoutConfigValue = configValues.get("net.sf.ehcache.hibernate.cache_lock_timeout");
            if (cacheLockTimeoutConfigValue != null) {
                Integer lockTimeoutInMillis = null;
                if (cacheLockTimeoutConfigValue instanceof String) {
                    lockTimeoutInMillis = Integer.decode((String)cacheLockTimeoutConfigValue);
                } else if (cacheLockTimeoutConfigValue instanceof Number) {
                    lockTimeoutInMillis = ((Number)cacheLockTimeoutConfigValue).intValue();
                }
                this.cacheLockTimeout = lockTimeoutInMillis != null ? (long)(4096 * lockTimeoutInMillis) : super.getTimeout();
            }
        }
    }

    protected CacheManager resolveCacheManager(SessionFactoryOptions settings, Map properties) {
        Object explicitCacheManager = properties.get("hibernate.cache.ehcache.cache_manager");
        if (explicitCacheManager != null) {
            return this.useExplicitCacheManager(settings, explicitCacheManager);
        }
        return EhcacheRegionFactory.useNormalCacheManager(settings, properties);
    }

    protected static CacheManager useNormalCacheManager(SessionFactoryOptions settings, Map properties) {
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get("net.sf.ehcache.configurationResourceName");
            }
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                Configuration configuration = ConfigurationFactory.parseConfiguration();
                HibernateEhcacheUtils.setCacheManagerNameIfNeeded(settings, configuration, properties);
                return new CacheManager(configuration);
            }
            URL url = EhcacheRegionFactory.loadResource(configurationResourceName, settings);
            Configuration configuration = HibernateEhcacheUtils.loadAndCorrectConfiguration(url);
            HibernateEhcacheUtils.setCacheManagerNameIfNeeded(settings, configuration, properties);
            return new CacheManager(configuration);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Attempt to restart an already started EhCacheRegionFactory. Use sessionFactory.close() between repeated calls to buildSessionFactory. Consider using SingletonEhCacheRegionFactory. Error from ehcache was: " + e.getMessage());
            }
            throw new CacheException((Throwable)e);
        }
    }

    private static URL loadResource(String configurationResourceName, SessionFactoryOptions settings) {
        URL url = ((ClassLoaderService)settings.getServiceRegistry().getService(ClassLoaderService.class)).locateResource(configurationResourceName);
        if (url == null) {
            ClassLoader standardClassloader = Thread.currentThread().getContextClassLoader();
            if (standardClassloader != null) {
                url = standardClassloader.getResource(configurationResourceName);
            }
            if (url == null) {
                url = EhcacheRegionFactory.class.getResource(configurationResourceName);
            }
            if (url == null) {
                try {
                    url = new URL(configurationResourceName);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Creating EhCacheRegionFactory from a specified resource: %s.  Resolved to URL: %s", configurationResourceName, url);
        }
        if (url == null) {
            EhCacheMessageLogger.INSTANCE.unableToLoadConfiguration(configurationResourceName);
        }
        return url;
    }

    protected URL loadResource(String configurationResourceName) {
        if (!super.isStarted()) {
            throw new IllegalStateException("Cannot load resource through a non-started EhcacheRegionFactory");
        }
        return EhcacheRegionFactory.loadResource(configurationResourceName, this.getOptions());
    }

    private CacheManager useExplicitCacheManager(SessionFactoryOptions settings, Object setting) {
        if (setting instanceof CacheManager) {
            return (CacheManager)setting;
        }
        Class cacheManagerClass = setting instanceof Class ? (Class)setting : ((ClassLoaderService)settings.getServiceRegistry().getService(ClassLoaderService.class)).classForName(setting.toString());
        try {
            return (CacheManager)cacheManagerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CacheException("Could not use explicit CacheManager : " + setting);
        }
    }

    protected void releaseFromUse() {
        try {
            this.cacheManager.shutdown();
        }
        finally {
            this.cacheManager = null;
        }
    }

    public long getTimeout() {
        return this.cacheLockTimeout;
    }
}

