/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import android.os.Looper;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.HandlerPoster;
import org.greenrobot.eventbus.Poster;

public interface MainThreadSupport {
    public boolean isMainThread();

    public Poster createPoster(EventBus var1);

    public static class AndroidHandlerMainThreadSupport
    implements MainThreadSupport {
        private final Looper looper;

        public AndroidHandlerMainThreadSupport(Looper looper) {
            this.looper = looper;
        }

        @Override
        public boolean isMainThread() {
            return this.looper == Looper.myLooper();
        }

        @Override
        public Poster createPoster(EventBus eventBus) {
            return new HandlerPoster(eventBus, this.looper, 10);
        }
    }
}

