/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainMonthDayPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.temporal.UnsupportedValueOfNodeGen;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.IsPartialTemporalObjectNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarIdentifierNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalMonthDayNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import java.util.List;

public class TemporalPlainMonthDayPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainMonthDayPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainMonthDayPrototypeBuiltins();

    protected TemporalPlainMonthDayPrototypeBuiltins() {
        super(JSTemporalPlainMonthDay.PROTOTYPE_NAME, TemporalPlainMonthDayPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainMonthDayPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayCalendarGetterNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: 
            case 2: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayGetterNodeGen.create(context, builtin, builtinEnum, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 3: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayWithNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayEqualsNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 5: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayToPlainDateNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 6: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayGetISOFieldsNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 7: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayToStringNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 8: 
            case 9: {
                return TemporalPlainMonthDayPrototypeBuiltinsFactory.JSTemporalPlainMonthDayToLocaleStringNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 10: {
                return UnsupportedValueOfNodeGen.create(context, builtin, TemporalPlainMonthDayPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainMonthDayPrototype implements BuiltinEnum<TemporalPlainMonthDayPrototype>
    {
        calendarId(0),
        monthCode(0),
        day(0),
        with(1),
        equals(1),
        toPlainDate(1),
        getISOFields(0),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0);

        private final int length;

        private TemporalPlainMonthDayPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendarId, monthCode, day).contains(this);
        }
    }

    public static abstract class JSTemporalPlainMonthDayCalendarGetterNode
    extends JSBuiltinNode {
        protected JSTemporalPlainMonthDayCalendarGetterNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString calendarId(JSTemporalPlainMonthDayObject monthDay, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier) {
            return toCalendarIdentifier.executeString(monthDay.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalMonthDay(monthDay)"})
        protected static Object invalidReceiver(Object monthDay) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }

    public static abstract class JSTemporalPlainMonthDayGetterNode
    extends JSBuiltinNode {
        protected final TemporalPlainMonthDayPrototype property;

        protected JSTemporalPlainMonthDayGetterNode(JSContext context, JSBuiltin builtin, TemporalPlainMonthDayPrototype property) {
            super(context, builtin);
            this.property = property;
        }

        @Specialization
        protected Object monthDayGetter(JSTemporalPlainMonthDayObject plainMD) {
            switch (this.property.ordinal()) {
                case 2: {
                    return plainMD.getDay();
                }
                case 1: {
                    return TemporalUtil.buildISOMonthCode(plainMD.getMonth());
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalMonthDay(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }

    public static abstract class JSTemporalPlainMonthDayWithNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainMonthDayWithNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainMonthDayObject with(JSTemporalPlainMonthDayObject temporalDate, Object temporalMonthDayLike, Object options, @Cached IsPartialTemporalObjectNode isPartialTemporalObjectNode, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!isPartialTemporalObjectNode.execute(temporalMonthDayLike)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorPartialTemporalObjectExpected();
            }
            TruffleString calendar = temporalDate.getCalendar();
            List<TruffleString> fieldNames = TemporalUtil.listDMMCY;
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), (Object)temporalDate, fieldNames, TemporalUtil.listEmpty);
            JSObject partialDate = TemporalUtil.prepareTemporalFields(this.getContext(), temporalMonthDayLike, fieldNames, null);
            fields = TemporalUtil.calendarMergeFields(this.getContext(), calendar, fields, partialDate);
            fields = TemporalUtil.prepareTemporalFields(this.getContext(), (Object)fields, fieldNames, TemporalUtil.listEmpty);
            JSDynamicObject resolvedOptions = this.getOptionsObject(options, this, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption((Object)resolvedOptions, getOptionNode);
            return monthDayFromFieldsNode.execute(calendar, fields, overflow);
        }

        @Specialization(guards={"!isJSTemporalMonthDay(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalMonthDayLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }

    public static abstract class JSTemporalPlainMonthDayEqualsNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainMonthDayEqualsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean equals(JSTemporalPlainMonthDayObject md, Object otherParam, @Cached ToTemporalCalendarIdentifierNode toCalendarIdentifier, @Cached ToTemporalMonthDayNode toTemporalMonthDayNode) {
            JSTemporalPlainMonthDayObject other = toTemporalMonthDayNode.execute(otherParam, (Object)Undefined.instance);
            if (md.getMonth() != other.getMonth()) {
                return false;
            }
            if (md.getDay() != other.getDay()) {
                return false;
            }
            if (md.getYear() != other.getYear()) {
                return false;
            }
            return TemporalUtil.calendarEquals(md.getCalendar(), other.getCalendar(), toCalendarIdentifier);
        }

        @Specialization(guards={"!isJSTemporalMonthDay(thisObj)"})
        protected static boolean invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }

    public static abstract class JSTemporalPlainMonthDayToPlainDateNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainMonthDayToPlainDateNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateObject toPlainDate(JSTemporalPlainMonthDayObject monthDay, Object item, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch) {
            if (!this.isObject(item)) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
            }
            TruffleString calendar = monthDay.getCalendar();
            List<TruffleString> receiverFieldNames = TemporalUtil.listDMC;
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), (Object)monthDay, receiverFieldNames, TemporalUtil.listEmpty);
            List<TruffleString> inputFieldNames = TemporalUtil.listY;
            JSObject inputFields = TemporalUtil.prepareTemporalFields(this.getContext(), (Object)TemporalUtil.toJSDynamicObject(item, this, errorBranch), inputFieldNames, TemporalUtil.listEmpty);
            JSDynamicObject mergedFields = TemporalUtil.calendarMergeFields(this.getContext(), calendar, fields, inputFields);
            List<TruffleString> mergedFieldNames = TemporalUtil.listJoinRemoveDuplicates(receiverFieldNames, inputFieldNames);
            mergedFields = TemporalUtil.prepareTemporalFields(this.getContext(), (Object)mergedFields, mergedFieldNames, TemporalUtil.listEmpty);
            return dateFromFieldsNode.execute(calendar, (Object)mergedFields, TemporalUtil.Overflow.CONSTRAIN);
        }

        @Specialization(guards={"!isJSTemporalMonthDay(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }

    public static abstract class JSTemporalPlainMonthDayGetISOFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainMonthDayGetISOFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public JSObject getISOFields(JSTemporalPlainMonthDayObject md) {
            JSObject obj = JSOrdinary.create(this.getContext(), this.getRealm());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.CALENDAR, md.getCalendar());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_DAY, md.getDay());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MONTH, md.getMonth());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_YEAR, md.getYear());
            return obj;
        }

        @Specialization(guards={"!isJSTemporalMonthDay(thisObj)"})
        protected static JSObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }

    public static abstract class JSTemporalPlainMonthDayToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainMonthDayToString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalPlainMonthDayObject md, Object optParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            return JSTemporalPlainMonthDay.temporalMonthDayToString(md, showCalendar);
        }

        @Specialization(guards={"!isJSTemporalMonthDay(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }

    public static abstract class JSTemporalPlainMonthDayToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainMonthDayToLocaleString(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString toLocaleString(JSTemporalPlainMonthDayObject thisMonthDay) {
            return JSTemporalPlainMonthDay.temporalMonthDayToString(thisMonthDay, TemporalUtil.ShowCalendar.AUTO);
        }

        @Specialization(guards={"!isJSTemporalMonthDay(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainMonthDayExpected();
        }
    }
}

