/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.CreateResolvingFunctionNode;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JobCallback;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AsyncContext;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;

public class PromiseResolveThenableNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private CreateResolvingFunctionNode createResolvingFunctions;
    @Node.Child
    private JSFunctionCallNode callResolveNode;
    @Node.Child
    private JSFunctionCallNode callRejectNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

    protected PromiseResolveThenableNode(JSContext context) {
        this.context = context;
        this.createResolvingFunctions = CreateResolvingFunctionNode.create(context);
        this.callResolveNode = JSFunctionCallNode.createCall();
    }

    public static PromiseResolveThenableNode create(JSContext context) {
        return new PromiseResolveThenableNode(context);
    }

    public Object executePromiseConstructor(JSPromiseObject promise, Object executor) {
        Pair<JSDynamicObject, JSDynamicObject> resolvingFunctions = this.createResolvingFunctions.execute(promise);
        JSDynamicObject resolve = resolvingFunctions.getFirst();
        JSDynamicObject reject = resolvingFunctions.getSecond();
        try {
            return this.callResolveNode.executeCall(JSArguments.create((Object)Undefined.instance, executor, new Object[]{resolve, reject}));
        }
        catch (AbstractTruffleException ex) {
            return this.callReject(reject, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JSPromiseObject promiseToResolve, Object thenable, JobCallback then) {
        Object object;
        Pair<JSDynamicObject, JSDynamicObject> resolvingFunctions = this.createResolvingFunctions.execute(promiseToResolve);
        JSDynamicObject resolve = resolvingFunctions.getFirst();
        JSDynamicObject reject = resolvingFunctions.getSecond();
        JSAgent agent = this.getRealm().getAgent();
        AsyncContext previousContextMapping = agent.asyncContextSwap(then.asyncContextSnapshot());
        try {
            object = this.callResolveNode.executeCall(JSArguments.create(thenable, then.callback(), new Object[]{resolve, reject}));
            agent.asyncContextSwap(previousContextMapping);
        }
        catch (Throwable throwable) {
            try {
                agent.asyncContextSwap(previousContextMapping);
                throw throwable;
            }
            catch (AbstractTruffleException ex) {
                return this.callReject(reject, ex);
            }
        }
        return object;
    }

    private Object callReject(JSDynamicObject reject, AbstractTruffleException exception) {
        if (this.getErrorObjectNode == null || this.callRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
            this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        Object error = this.getErrorObjectNode.execute(exception);
        return this.callRejectNode.executeCall(JSArguments.create((Object)Undefined.instance, (Object)reject, error));
    }
}

