/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNodeGen;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

@GenerateInline
@GenerateUncached
@ImportStatic(value={JSInteropUtil.class})
public abstract class GetIteratorNode
extends JavaScriptBaseNode {
    protected GetIteratorNode() {
    }

    public final IteratorRecord execute(Node node, Object iteratedObject) {
        return this.execute(node, iteratedObject, (Object)Undefined.instance);
    }

    public abstract IteratorRecord execute(Node var1, Object var2, Object var3);

    @NeverDefault
    public static GetIteratorNode create() {
        return GetIteratorNodeGen.create();
    }

    public static GetIteratorNode getUncached() {
        return GetIteratorNodeGen.getUncached();
    }

    @Specialization
    protected static IteratorRecord doGetIterator(Node node, Object items, Object methodOpt, @Cached(value="createIteratorMethodNode()", uncached="uncachedIteratorMethodNode()", inline=false) GetMethodNode getIteratorMethodNode, @Cached(inline=false) IsCallableNode isCallableNode, @Cached(value="createCall()", uncached="getUncachedCall()", inline=false) JSFunctionCallNode iteratorCallNode, @Cached(inline=false) IsObjectNode isObjectNode, @Cached(value="createNextMethodNode()", uncached="uncachedNextMethodNode()", inline=false) PropertyGetNode getNextMethodNode, @Cached InlinedBranchProfile errorBranch) {
        Object method = methodOpt != Undefined.instance ? methodOpt : (getIteratorMethodNode == null ? GetIteratorNode.getIteratorMethodUncached(items) : getIteratorMethodNode.executeWithTarget(items));
        return GetIteratorNode.getIterator(items, method, isCallableNode, iteratorCallNode, isObjectNode, getNextMethodNode, errorBranch, node);
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object getIteratorMethodUncached(Object items) {
        Object obj = JSRuntime.toObject(items);
        JSDynamicObject target = obj instanceof JSDynamicObject ? (JSDynamicObject)((Object)obj) : ForeignObjectPrototypeNode.getUncached().execute(obj);
        return JSObject.getOrDefault(target, Symbol.SYMBOL_ITERATOR, obj, (Object)Undefined.instance);
    }

    public static IteratorRecord getIterator(Object iteratedObject, Object method, IsCallableNode isCallableNode, JSFunctionCallNode methodCallNode, IsObjectNode isObjectNode, PropertyGetNode getNextMethodNode, InlinedBranchProfile errorBranch, Node node) {
        if (!isCallableNode.executeBoolean(method)) {
            errorBranch.enter(node);
            throw Errors.createTypeErrorNotIterable(iteratedObject, node);
        }
        return GetIteratorNode.getIterator(iteratedObject, method, methodCallNode, isObjectNode, getNextMethodNode, node);
    }

    public static IteratorRecord getIterator(Object iteratedObject, Object method, JSFunctionCallNode methodCallNode, IsObjectNode isObjectNode, PropertyGetNode getNextMethodNode, Node node) {
        Object iterator = methodCallNode.executeCall(JSArguments.createZeroArg(iteratedObject, method));
        if (isObjectNode.executeBoolean(iterator)) {
            Object nextMethod = getNextMethodNode == null ? JSRuntime.get(iterator, Strings.NEXT) : getNextMethodNode.getValue(iterator);
            return IteratorRecord.create(iterator, nextMethod, false);
        }
        throw Errors.createTypeErrorNotAnObject(iterator, node);
    }

    @NeverDefault
    GetMethodNode createIteratorMethodNode() {
        return GetMethodNode.create(this.getLanguage().getJSContext(), Symbol.SYMBOL_ITERATOR);
    }

    static GetMethodNode uncachedIteratorMethodNode() {
        return null;
    }

    @NeverDefault
    PropertyGetNode createNextMethodNode() {
        return PropertyGetNode.create(Strings.NEXT, this.getLanguage().getJSContext());
    }

    static PropertyGetNode uncachedNextMethodNode() {
        return null;
    }
}

