/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.asynccontext;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.asynccontext.AsyncContextSnapshotPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextSnapshot;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextSnapshotObject;
import com.oracle.truffle.js.runtime.objects.AsyncContext;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class AsyncContextSnapshotPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<AsyncContextSnapshotPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncContextSnapshotPrototypeBuiltins();

    protected AsyncContextSnapshotPrototypeBuiltins() {
        super(JSAsyncContextSnapshot.PROTOTYPE_NAME, AsyncContextSnapshotPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, AsyncContextSnapshotPrototype builtinEnum) {
        switch (builtinEnum) {
            case run: {
                return AsyncContextSnapshotPrototypeBuiltinsFactory.RunNodeGen.create(context, builtin, AsyncContextSnapshotPrototypeBuiltins.args().withThis().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum AsyncContextSnapshotPrototype implements BuiltinEnum<AsyncContextSnapshotPrototype>
    {
        run(1);

        private final int length;

        private AsyncContextSnapshotPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSAsyncContextSnapshot.class})
    public static abstract class RunNode
    extends JSBuiltinNode {
        public RunNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doCallable(JSAsyncContextSnapshotObject asyncSnapshotObj, Object func, Object[] args, @Cached(value="createCall()") JSFunctionCallNode callFunc) {
            JSAgent agent = this.getRealm().getAgent();
            AsyncContext snapshot = asyncSnapshotObj.getAsyncSnapshotMapping();
            AsyncContext previousContextMapping = agent.asyncContextSwap(snapshot);
            try {
                Object object = callFunc.executeCall(JSArguments.create((Object)Undefined.instance, func, args));
                return object;
            }
            finally {
                agent.asyncContextSwap(previousContextMapping);
            }
        }

        @Specialization(guards={"!isJSAsyncContextSnapshot(thisObj)"})
        protected Object invalidReceiver(Object thisObj, Object func, Object[] args) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }
}

