/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface SharedConstants {
    public static final boolean IS_WINDOWS = System.getProperty("os.name", "unknown").contains("Windows");
    public static final boolean IS_CI = System.getenv("CI") != null;
    public static final boolean IS_DUMB_TERM = Arrays.asList(null, "", "dumb", "unknown").contains(System.getenv("TERM"));
    public static final boolean NO_COLOR = System.getenv("NO_COLOR") != null;
    public static final String GRAALVM_EXE_EXTENSION = IS_WINDOWS ? ".cmd" : "";
    public static final String EXECUTABLE_EXTENSION = IS_WINDOWS ? ".exe" : "";
    public static final String NATIVE_IMAGE_EXE = "native-image" + GRAALVM_EXE_EXTENSION;
    public static final String GU_EXE = "gu" + GRAALVM_EXE_EXTENSION;
    public static final String NATIVE_IMAGE_OUTPUT_FOLDER = "native";
    public static final String AGENT_PROPERTY = "agent";
    public static final String AGENT_OUTPUT_FOLDER = "native/agent-output";
    public static final String NATIVE_TESTS_SUFFIX = "-tests";
    public static final List<String> DEFAULT_EXCLUDES_FOR_RESOURCE_DETECTION = Collections.unmodifiableList(Arrays.asList("META-INF/services/.*", "META-INF/native-image/.*", "META-INF/maven/.*", "META-INF/LICENSE.*", "META-INF/NOTICE.*", "META-INF/.*[.](md|adoc)", "META-INF/INDEX.LIST", ".*/package.html"));
    public static final String AGENT_SESSION_SUBDIR = "session-{pid}-{datetime}";
    public static final String AGENT_OUTPUT_DIRECTORY_MARKER = "{output_dir}";
    public static final String AGENT_OUTPUT_DIRECTORY_OPTION = "config-output-dir=";
    public static final String METADATA_REPO_URL_TEMPLATE = "https://github.com/oracle/graalvm-reachability-metadata/releases/download/%1$s/graalvm-reachability-metadata-%1$s.zip";
    @Deprecated
    public static final String METADATA_REPO_DEFAULT_VERSION = "0.2.5";
}

