/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api.models;

import java.util.ArrayList;
import java.util.List;
import org.gitlab4j.api.models.CommitAction;
import org.gitlab4j.api.utils.JacksonJson;

public class CommitPayload {
    private String branch;
    private String commitMessage;
    private String startBranch;
    private String startSha;
    private Object startProject;
    private List<CommitAction> actions;
    private String authorEmail;
    private String authorName;
    private Boolean stats;
    private Boolean force;

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public CommitPayload withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public CommitPayload withCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    public String getStartBranch() {
        return this.startBranch;
    }

    public void setStartBranch(String startBranch) {
        this.startBranch = startBranch;
    }

    public CommitPayload withStartBranch(String startBranch) {
        this.startBranch = startBranch;
        return this;
    }

    public String getStartSha() {
        return this.startSha;
    }

    public void setStartSha(String startSha) {
        this.startSha = startSha;
    }

    public CommitPayload withStartSha(String startSha) {
        this.startSha = startSha;
        return this;
    }

    public Object getStartProject() {
        return this.startProject;
    }

    public void setStartProject(Object startProject) {
        this.startProject = startProject;
    }

    public CommitPayload withStartProject(Object startProject) {
        this.startProject = startProject;
        return this;
    }

    public List<CommitAction> getActions() {
        return this.actions;
    }

    public void setActions(List<CommitAction> actions) {
        this.actions = actions;
    }

    public CommitPayload withActions(List<CommitAction> actions) {
        this.actions = actions;
        return this;
    }

    public CommitPayload withAction(CommitAction action) {
        if (this.actions == null) {
            this.actions = new ArrayList<CommitAction>();
        }
        this.actions.add(action);
        return this;
    }

    public CommitPayload withAction(CommitAction.Action action, String filePath) {
        return this.withAction(action, null, filePath);
    }

    public CommitPayload withAction(CommitAction.Action action, String content, String filePath) {
        CommitAction commitAction = new CommitAction().withAction(action).withContent(content).withFilePath(filePath);
        return this.withAction(commitAction);
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
    }

    public CommitPayload withAuthorEmail(String authorEmail) {
        this.authorEmail = authorEmail;
        return this;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public CommitPayload withAuthorName(String authorName) {
        this.authorName = authorName;
        return this;
    }

    public Boolean getStats() {
        return this.stats;
    }

    public void setStats(Boolean stats) {
        this.stats = stats;
    }

    public CommitPayload withStats(Boolean stats) {
        this.stats = stats;
        return this;
    }

    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public CommitPayload withForce(Boolean force) {
        this.force = force;
        return this;
    }

    public String toString() {
        return JacksonJson.toJsonString(this);
    }
}

