/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.spring.autodeployment;

import java.io.IOException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.springframework.core.io.Resource;

public class SingleResourceAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    public static final String DEPLOYMENT_MODE = "single-resource";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, DmnRepositoryService repositoryService) {
        for (Resource resource : resources) {
            String resourceName = this.determineResourceName(resource);
            DmnDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(resourceName);
            try {
                deploymentBuilder.addInputStream(resourceName, resource.getInputStream());
            }
            catch (IOException e) {
                throw new FlowableException("couldn't auto deploy resource '" + resource + "': " + e.getMessage(), (Throwable)e);
            }
            deploymentBuilder.deploy();
        }
    }
}

