/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history;

import java.util.Date;
import java.util.function.Consumer;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryHelper;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricMilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricMilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class DefaultCmmnHistoryManager
implements CmmnHistoryManager {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public DefaultCmmnHistoryManager(CmmnEngineConfiguration cmmnEngineConfiguration) {
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    @Override
    public void recordCaseInstanceStart(CaseInstanceEntity caseInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager();
            HistoricCaseInstanceEntity historicCaseInstanceEntity = (HistoricCaseInstanceEntity)this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager().create();
            historicCaseInstanceEntity.setId(caseInstanceEntity.getId());
            historicCaseInstanceEntity.setName(caseInstanceEntity.getName());
            historicCaseInstanceEntity.setBusinessKey(caseInstanceEntity.getBusinessKey());
            historicCaseInstanceEntity.setParentId(caseInstanceEntity.getParentId());
            historicCaseInstanceEntity.setCaseDefinitionId(caseInstanceEntity.getCaseDefinitionId());
            historicCaseInstanceEntity.setState(caseInstanceEntity.getState());
            historicCaseInstanceEntity.setStartUserId(caseInstanceEntity.getStartUserId());
            historicCaseInstanceEntity.setStartTime(caseInstanceEntity.getStartTime());
            historicCaseInstanceEntity.setTenantId(caseInstanceEntity.getTenantId());
            historicCaseInstanceEntityManager.insert(historicCaseInstanceEntity);
        }
    }

    @Override
    public void recordCaseInstanceEnd(CaseInstanceEntity caseInstanceEntity, String state) {
        HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager;
        HistoricCaseInstanceEntity historicCaseInstanceEntity;
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY) && (historicCaseInstanceEntity = (HistoricCaseInstanceEntity)(historicCaseInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricCaseInstanceEntityManager()).findById(caseInstanceEntity.getId())) != null) {
            historicCaseInstanceEntity.setEndTime(this.cmmnEngineConfiguration.getClock().getCurrentTime());
            historicCaseInstanceEntity.setState(state);
        }
    }

    @Override
    public void recordMilestoneReached(MilestoneInstanceEntity milestoneInstance) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricMilestoneInstanceEntityManager historicMilestoneInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricMilestoneInstanceEntityManager();
            HistoricMilestoneInstanceEntity historicMilestoneInstanceEntity = (HistoricMilestoneInstanceEntity)historicMilestoneInstanceEntityManager.create();
            historicMilestoneInstanceEntity.setId(milestoneInstance.getId());
            historicMilestoneInstanceEntity.setName(milestoneInstance.getName());
            historicMilestoneInstanceEntity.setCaseInstanceId(milestoneInstance.getCaseInstanceId());
            historicMilestoneInstanceEntity.setCaseDefinitionId(milestoneInstance.getCaseDefinitionId());
            historicMilestoneInstanceEntity.setElementId(milestoneInstance.getElementId());
            historicMilestoneInstanceEntity.setTimeStamp(this.cmmnEngineConfiguration.getClock().getCurrentTime());
            historicMilestoneInstanceEntity.setTenantId(milestoneInstance.getTenantId());
            historicMilestoneInstanceEntityManager.insert(historicMilestoneInstanceEntity);
        }
    }

    @Override
    public void recordHistoricCaseInstanceDeleted(String caseInstanceId) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            CmmnHistoryHelper.deleteHistoricCaseInstance(this.cmmnEngineConfiguration, caseInstanceId);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE && (identityLink.getScopeId() != null || identityLink.getTaskId() != null)) {
            HistoricIdentityLinkService historicIdentityLinkService = CommandContextUtil.getHistoricIdentityLinkService();
            HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
            historicIdentityLinkEntity.setId(identityLink.getId());
            historicIdentityLinkEntity.setGroupId(identityLink.getGroupId());
            historicIdentityLinkEntity.setScopeDefinitionId(identityLink.getScopeDefinitionId());
            historicIdentityLinkEntity.setScopeId(identityLink.getScopeId());
            if (identityLink.getScopeId() != null) {
                historicIdentityLinkEntity.setScopeType("cmmn");
            }
            historicIdentityLinkEntity.setTaskId(identityLink.getTaskId());
            historicIdentityLinkEntity.setType(identityLink.getType());
            historicIdentityLinkEntity.setUserId(identityLink.getUserId());
            historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        if (this.cmmnEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE) {
            CommandContextUtil.getHistoricIdentityLinkService().deleteHistoricIdentityLink(identityLink.getId());
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            CommandContextUtil.getHistoricVariableService().createAndInsert(variable);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variableInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            CommandContextUtil.getHistoricVariableService().recordVariableUpdate(variableInstanceEntity);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variableInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            CommandContextUtil.getHistoricVariableService().recordVariableRemoved(variableInstanceEntity);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            CommandContextUtil.getHistoricTaskService().recordTaskCreated(task);
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, String deleteReason) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            CommandContextUtil.getHistoricTaskService().recordTaskEnd(task, deleteReason);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            CommandContextUtil.getHistoricTaskService().recordTaskInfoChange(taskEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceCreated(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager();
            HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity = (HistoricPlanItemInstanceEntity)historicPlanItemInstanceEntityManager.create();
            historicPlanItemInstanceEntity.setId(planItemInstanceEntity.getId());
            historicPlanItemInstanceEntity.setName(planItemInstanceEntity.getName());
            historicPlanItemInstanceEntity.setState(planItemInstanceEntity.getState());
            historicPlanItemInstanceEntity.setCaseDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            historicPlanItemInstanceEntity.setCaseInstanceId(planItemInstanceEntity.getCaseInstanceId());
            historicPlanItemInstanceEntity.setStageInstanceId(planItemInstanceEntity.getStageInstanceId());
            historicPlanItemInstanceEntity.setStage(planItemInstanceEntity.isStage());
            historicPlanItemInstanceEntity.setElementId(planItemInstanceEntity.getElementId());
            historicPlanItemInstanceEntity.setPlanItemDefinitionId(planItemInstanceEntity.getPlanItemDefinitionId());
            historicPlanItemInstanceEntity.setPlanItemDefinitionType(planItemInstanceEntity.getPlanItemDefinitionType());
            historicPlanItemInstanceEntity.setStartUserId(planItemInstanceEntity.getStartUserId());
            historicPlanItemInstanceEntity.setReferenceId(planItemInstanceEntity.getReferenceId());
            historicPlanItemInstanceEntity.setReferenceType(planItemInstanceEntity.getReferenceType());
            historicPlanItemInstanceEntity.setTenantId(planItemInstanceEntity.getTenantId());
            historicPlanItemInstanceEntity.setCreatedTime(planItemInstanceEntity.getStartTime());
            historicPlanItemInstanceEntityManager.insert(historicPlanItemInstanceEntity);
        }
    }

    @Override
    public void recordPlanItemInstanceAvailable(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> h.setLastAvailableTime(this.cmmnEngineConfiguration.getClock().getCurrentTime()));
    }

    @Override
    public void recordPlanItemInstanceEnabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> h.setLastEnabledTime(this.cmmnEngineConfiguration.getClock().getCurrentTime()));
    }

    @Override
    public void recordPlanItemInstanceDisabled(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> h.setLastDisabledTime(this.cmmnEngineConfiguration.getClock().getCurrentTime()));
    }

    @Override
    public void recordPlanItemInstanceStarted(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> h.setLastStartedTime(this.cmmnEngineConfiguration.getClock().getCurrentTime()));
    }

    @Override
    public void recordPlanItemInstanceSuspended(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> h.setLastSuspendedTime(this.cmmnEngineConfiguration.getClock().getCurrentTime()));
    }

    @Override
    public void recordPlanItemInstanceCompleted(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> {
            Date currentTime = this.cmmnEngineConfiguration.getClock().getCurrentTime();
            h.setEndedTime(currentTime);
            h.setCompletedTime(currentTime);
        });
    }

    @Override
    public void recordPlanItemInstanceTerminated(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> {
            Date currentTime = this.cmmnEngineConfiguration.getClock().getCurrentTime();
            h.setEndedTime(currentTime);
            h.setTerminatedTime(currentTime);
        });
    }

    @Override
    public void recordPlanItemInstanceOccurred(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> {
            Date currentTime = this.cmmnEngineConfiguration.getClock().getCurrentTime();
            h.setEndedTime(currentTime);
            h.setOccurredTime(currentTime);
        });
    }

    @Override
    public void recordPlanItemInstanceExit(PlanItemInstanceEntity planItemInstanceEntity) {
        this.recordHistoricPlanItemInstanceEntity(planItemInstanceEntity, h -> {
            Date currentTime = this.cmmnEngineConfiguration.getClock().getCurrentTime();
            h.setEndedTime(currentTime);
            h.setExitTime(currentTime);
        });
    }

    protected void recordHistoricPlanItemInstanceEntity(PlanItemInstanceEntity planItemInstanceEntity, Consumer<HistoricPlanItemInstanceEntity> changes) {
        HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager;
        HistoricPlanItemInstanceEntity historicPlanItemInstanceEntity;
        if (this.cmmnEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.ACTIVITY) && (historicPlanItemInstanceEntity = (HistoricPlanItemInstanceEntity)(historicPlanItemInstanceEntityManager = this.cmmnEngineConfiguration.getHistoricPlanItemInstanceEntityManager()).findById(planItemInstanceEntity.getId())) != null) {
            historicPlanItemInstanceEntity.setState(planItemInstanceEntity.getState());
            historicPlanItemInstanceEntity.setLastUpdatedTime(this.cmmnEngineConfiguration.getClock().getCurrentTime());
            changes.accept(historicPlanItemInstanceEntity);
        }
    }
}

